% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{rPosteriorPredictive.CatHDP}
\alias{rPosteriorPredictive.CatHDP}
\title{Generate random samples from the posterior predictive distribution of a "CatHDP" object}
\usage{
\method{rPosteriorPredictive}{CatHDP}(obj, n = 1L, j, ...)
}
\arguments{
\item{obj}{A "CatHDP" object.}

\item{n}{integer, number of samples.}

\item{j}{integer, group label.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
integer, the categorical samples.
}
\description{
Generate random samples from the posterior predictive distribution of the following structure:
     \deqn{G|gamma \sim DP(gamma,U)}
     \deqn{pi_j|G,alpha \sim DP(alpha,G), j = 1:J}
     \deqn{z|pi_j \sim Categorical(pi_j)}
     \deqn{k|z,G \sim Categorical(G), \textrm{ if z is a sample from the base measure G}}
where DP(gamma,U) is a Dirichlet Process on positive integers, gamma is the "concentration parameter", U is the "base measure" of this Dirichlet process, U is an uniform distribution on all positive integers.  DP(alpha,G) is a Dirichlet Process on integers with concentration parameter alpha and base measure G. Categorical() is the Categorical distribution. See \code{dCategorical} for the definition of the Categorical distribution. \cr
In the case of CatHDP, z and k can only be positive integers. \cr
The model structure and prior parameters are stored in a "CatHDP" object. \cr
Posterior predictive is a distribution of z,k|alpha,gamma,U.
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{CatHDP}}, \code{\link{dPosteriorPredictive.CatHDP}}
}
