% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{rPosterior.GaussianInvWishart}
\alias{rPosterior.GaussianInvWishart}
\title{Generate one ramdom sample from the posterior distribution of a "GaussianInvWishart" object}
\usage{
\method{rPosterior}{GaussianInvWishart}(obj, ...)
}
\arguments{
\item{obj}{A "GaussianInvWishart" object.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
matrix, a sample of Sigma.
}
\description{
Generate random samples from the posterior distribution of the following structure:
    \deqn{x ~ Gaussian(mu,Sigma)}
    \deqn{Sigma ~ InvWishart(v,S)}
mu is known. Gaussian() is the Gaussian distribution. See \code{?dGaussian} and \code{?dInvWishart} for the definition of the distributions.\cr
The model structure and prior parameters are stored in a "GaussianInvWishart" object. \cr
Posterior distribution is InvWishart(Sigma|v,S).
}
\examples{
obj <- GaussianInvWishart(gamma=list(mu=c(-1.5,1.5),v=3,S=diag(2)))
rPosterior(obj = obj)
}
\seealso{
\code{\link{GaussianInvWishart}}, \code{\link{dPosterior.GaussianInvWishart}}
}
