% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ContextAsync.R
\name{ContextAsync}
\alias{ContextAsync}
\title{Asynchronous Optimization Context}
\description{
A \link{CallbackAsync} accesses and modifies data during the optimization via the \code{ContextAsync}.
See the section on active bindings for a list of modifiable objects.
See \code{\link[=callback_async]{callback_async()}} for a list of stages which access \code{ContextAsync}.
}
\details{
Changes to \verb{$instance} and \verb{$optimizer} in the stages executed on the workers are not reflected in the main process.
}
\seealso{
\link{CallbackAsync}
}
\section{Super class}{
\code{\link[mlr3misc:Context]{mlr3misc::Context}} -> \code{ContextAsync}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{instance}}{(\link{OptimInstance}).}

\item{\code{optimizer}}{(\link{Optimizer}).}

\item{\code{queue}}{\code{logical(1)}\cr
Whether the point is from the queue.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{xs}}{(list())\cr
The point to be evaluated in \code{instance$.eval_point()}.}

\item{\code{xs_trafoed}}{(list())\cr
The transformed point to be evaluated in \code{instance$.eval_point()}.}

\item{\code{extra}}{(list())\cr
Additional information of the point to be evaluated in \code{instance$.eval_point()}.}

\item{\code{ys}}{(list())\cr
The result of the evaluation in \code{instance$.eval_point()}.}

\item{\code{result_xdt}}{(\link[data.table:data.table]{data.table::data.table})\cr
The xdt passed to \code{instance$assign_result()}.}

\item{\code{result_y}}{(\code{numeric(1)})\cr
The y passed to \code{instance$assign_result()}.
Only available for single criterion optimization.}

\item{\code{result_ydt}}{(\link[data.table:data.table]{data.table::data.table})\cr
The ydt passed to \code{instance$assign_result()}.
Only available for multi criterion optimization.}

\item{\code{result_extra}}{(\link[data.table:data.table]{data.table::data.table})\cr
Additional information about the result passed to \code{instance$assign_result()}.}

\item{\code{result}}{(\link[data.table:data.table]{data.table::data.table})\cr
The result of the optimization in \code{instance$assign_result()}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ContextAsync-new}{\code{ContextAsync$new()}}
\item \href{#method-ContextAsync-clone}{\code{ContextAsync$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Context" data-id="format"><a href='../../mlr3misc/html/Context.html#method-Context-format'><code>mlr3misc::Context$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Context" data-id="print"><a href='../../mlr3misc/html/Context.html#method-Context-print'><code>mlr3misc::Context$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ContextAsync-new"></a>}}
\if{latex}{\out{\hypertarget{method-ContextAsync-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContextAsync$new(inst, optimizer)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inst}}{(\link{OptimInstance}).}

\item{\code{optimizer}}{(\link{Optimizer}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ContextAsync-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ContextAsync-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContextAsync$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
