% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TerminatorEvals.R
\name{mlr_terminators_evals}
\alias{mlr_terminators_evals}
\alias{TerminatorEvals}
\title{Terminator that stops after a number of evaluations}
\description{
Class to terminate the optimization depending on the number of evaluations.
An evaluation is defined by one resampling of a parameter value.
The total number of evaluations \eqn{B} is defined as

\deqn{
   B = \mathtt{n\_evals} + \mathtt{k} * D
}{
   B = n_evals + k * D
}
where \eqn{D} is the dimension of the search space.
}
\section{Dictionary}{

This \link{Terminator} can be instantiated via the
\link[mlr3misc:Dictionary]{dictionary} \link{mlr_terminators} or with the associated
sugar function \code{\link[=trm]{trm()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_terminators$get("evals")
trm("evals")
}\if{html}{\out{</div>}}
}

\section{Parameters}{

\describe{
\item{\code{n_evals}}{\code{integer(1)}\cr
See formula above. Default is 100.}
\item{\code{k}}{\code{integer(1)}\cr
See formula above. Default is 0.}
}
}

\examples{
TerminatorEvals$new()

# 5 evaluations in total
trm("evals", n_evals = 5)

# 3 * [dimension of search space] evaluations in total
trm("evals", n_evals = 0, k = 3)

# (3 * [dimension of search space] + 1) evaluations in total
trm("evals", n_evals = 1, k = 3)
}
\seealso{
Other Terminator: 
\code{\link{Terminator}},
\code{\link{mlr_terminators_clock_time}},
\code{\link{mlr_terminators_combo}},
\code{\link{mlr_terminators_none}},
\code{\link{mlr_terminators_perf_reached}},
\code{\link{mlr_terminators_run_time}},
\code{\link{mlr_terminators_stagnation_batch}},
\code{\link{mlr_terminators_stagnation}},
\code{\link{mlr_terminators}}
}
\concept{Terminator}
\section{Super class}{
\code{\link[bbotk:Terminator]{bbotk::Terminator}} -> \code{TerminatorEvals}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TerminatorEvals-new}{\code{TerminatorEvals$new()}}
\item \href{#method-TerminatorEvals-is_terminated}{\code{TerminatorEvals$is_terminated()}}
\item \href{#method-TerminatorEvals-clone}{\code{TerminatorEvals$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="format"><a href='../../bbotk/html/Terminator.html#method-Terminator-format'><code>bbotk::Terminator$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="print"><a href='../../bbotk/html/Terminator.html#method-Terminator-print'><code>bbotk::Terminator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="remaining_time"><a href='../../bbotk/html/Terminator.html#method-Terminator-remaining_time'><code>bbotk::Terminator$remaining_time()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="status"><a href='../../bbotk/html/Terminator.html#method-Terminator-status'><code>bbotk::Terminator$status()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TerminatorEvals-new"></a>}}
\if{latex}{\out{\hypertarget{method-TerminatorEvals-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TerminatorEvals$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TerminatorEvals-is_terminated"></a>}}
\if{latex}{\out{\hypertarget{method-TerminatorEvals-is_terminated}{}}}
\subsection{Method \code{is_terminated()}}{
Is \code{TRUE} iff the termination criterion is positive, and \code{FALSE}
otherwise.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TerminatorEvals$is_terminated(archive)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{archive}}{(\link{Archive}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{logical(1)}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TerminatorEvals-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TerminatorEvals-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TerminatorEvals$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
