% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimizerFocusSearch.R
\name{shrink_ps}
\alias{shrink_ps}
\title{Shrink a ParamSet towards a point.}
\usage{
shrink_ps(param_set, x, check.feasible = FALSE)
}
\arguments{
\item{param_set}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
The \link[paradox:ParamSet]{paradox::ParamSet} to be shrinked.}

\item{x}{(\link[data.table:data.table]{data.table::data.table})\cr
\link[data.table:data.table]{data.table::data.table} with one row containing the point to shrink
around.}

\item{check.feasible}{(\code{logical(1)})\cr
Should feasibility of the parameters be checked?
If feasibility is not checked, and invalid values are present, no shrinking
will be done.
Must be turned off in the case of the \link[paradox:ParamSet]{paradox::ParamSet} having a trafo.
Default is \code{FALSE}.}
}
\value{
\link[paradox:ParamSet]{paradox::ParamSet}
}
\description{
Shrinks a \link[paradox:ParamSet]{paradox::ParamSet} towards a point.
Boundaries of numeric values are shrinked to an interval around the point of
half of the previous length, while for discrete variables, a random
(currently not chosen) level is dropped.

Note that for \link[paradox:ParamLgl]{paradox::ParamLgl}s the value to be shrinked around is set as
the \code{default} value instead of dropping a level. Also, a tag \code{shrinked} is
added.

If the \link[paradox:ParamSet]{paradox::ParamSet} has a trafo, \code{x} is expected to contain the
transformed values.
}
\examples{
library(paradox)
library(data.table)
param_set = ParamSet$new(list(
  ParamDbl$new("x1", lower = 0, upper = 10),
  ParamInt$new("x2", lower = -10, upper = 10),
  ParamFct$new("x3", levels = c("a", "b", "c")),
  ParamLgl$new("x4"))
)
x = data.table(x1 = 5, x2 = 0, x3 = "b", x4 = FALSE)
shrink_ps(param_set, x = x)
}
