% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ObjectiveRFunDt.R
\name{ObjectiveRFunDt}
\alias{ObjectiveRFunDt}
\title{Objective interface for basic R functions.}
\description{
Objective interface where user can pass an R function that works on an \code{data.table()}.
}
\section{Super class}{
\code{\link[bbotk:Objective]{bbotk::Objective}} -> \code{ObjectiveRFunDt}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{fun}}{(\code{function})\cr
Objective function.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ObjectiveRFunDt$new()}}
\item \href{#method-eval_many}{\code{ObjectiveRFunDt$eval_many()}}
\item \href{#method-eval_dt}{\code{ObjectiveRFunDt$eval_dt()}}
\item \href{#method-clone}{\code{ObjectiveRFunDt$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="eval">}\href{../../bbotk/html/Objective.html#method-eval}{\code{bbotk::Objective$eval()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="format">}\href{../../bbotk/html/Objective.html#method-format}{\code{bbotk::Objective$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="print">}\href{../../bbotk/html/Objective.html#method-print}{\code{bbotk::Objective$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ObjectiveRFunDt$new(
  fun,
  domain,
  codomain = NULL,
  id = "function",
  properties = character(),
  constants = ParamSet$new(),
  check_values = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fun}}{(\code{function})\cr
R function that encodes objective and expects an \code{data.table()} as input
whereas each point is represented by one row.}

\item{\code{domain}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Specifies domain of function.
The \link[paradox:ParamSet]{paradox::ParamSet} should describe all possible input parameters of the objective function.
This includes their \code{id}, their types and the possible range.}

\item{\code{codomain}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Specifies codomain of function.
Most importantly the tags of each output "Parameter" define whether it should
be minimized or maximized.  The default is to minimize each component.}

\item{\code{id}}{(\code{character(1)}).}

\item{\code{properties}}{(\code{character()}).}

\item{\code{constants}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Changeable constants or parameters that are not subject to tuning can be stored and accessed here.}

\item{\code{check_values}}{(\code{logical(1)})\cr
Should points before the evaluation and the results be checked for
validity?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-eval_many"></a>}}
\if{latex}{\out{\hypertarget{method-eval_many}{}}}
\subsection{Method \code{eval_many()}}{
Evaluates multiple input values received as a list, converted to a \code{data.table()} on the
objective function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ObjectiveRFunDt$eval_many(xss)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xss}}{(\code{list()})\cr
A list of lists that contains multiple x values, e.g.
\code{list(list(x1 = 1, x2 = 2), list(x1 = 3, x2 = 4))}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}} that contains one y-column for single-criteria functions
and multiple y-columns for multi-criteria functions, e.g.
\code{data.table(y = 1:2)} or \code{data.table(y1 = 1:2, y2 = 3:4)}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-eval_dt"></a>}}
\if{latex}{\out{\hypertarget{method-eval_dt}{}}}
\subsection{Method \code{eval_dt()}}{
Evaluates multiple input values on the objective function supplied by the user.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ObjectiveRFunDt$eval_dt(xdt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xdt}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Set of untransformed points / points from the \emph{search space}.
One point per row, e.g. \code{data.table(x1 = c(1, 3), x2 = c(2, 4))}.
Column names have to match ids of the \code{search_space}.
However, \code{xdt} can contain additional columns.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
data.table::data.table()] that contains one y-column for single-criteria functions
and multiple y-columns for multi-criteria functions, e.g.
\code{data.table(y = 1:2)} or \code{data.table(y1 = 1:2, y2 = 3:4)}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ObjectiveRFunDt$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
