% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.R
\name{randomsamp}
\alias{randomsamp}
\title{Generate Random Boltzmann Bayes Model Data}
\usage{
randomsamp(predictors, response, prob = NULL, par, nsample = 100)
}
\arguments{
\item{predictors}{List of vectors of predictor levels}

\item{response}{Vector of response variables}

\item{prob}{Vector of probabilities for sampling each response group}

\item{par}{List of \code{\link{bbl}} parameters for each response group;
e.g., generated from calls to \code{\link{randompar}}.}

\item{nsample}{Sample size}
}
\value{
Data frame of response and predictor variables.
}
\description{
Predictor-response paired data are generated
}
\details{
The argument \code{response} is used to set up all possible levels
of response groups and likewise for \code{predictors}. The parameter
argument \code{\link{par}} must have the appropriate structure
consistent with \code{response} and \code{predictors}. This function
is a wrapper calling \code{\link{sample_xi}} multiple times.
}
