% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.na.R
\name{as.na}
\alias{as.na}
\alias{as.na.default}
\alias{as.na.data.frame}
\alias{as.na.list}
\title{Transform values to NA}
\usage{
as.na(x, ...)

\method{as.na}{default}(x, ...)

\method{as.na}{data.frame}(x, ...)

\method{as.na}{list}(x, ...)
}
\arguments{
\item{x}{The object at stake.}

\item{...}{Additional arguments (unused).}
}
\value{
An object of the same class as \code{x}; 
the attributes of \code{x} are passed unchanged to the result.
}
\description{
These methods transform values to \code{\link[base]{NA}} 
for different classes of objects.
}
\examples{
x <- c("a", "b", "c")
as.na(x)
class(as.na(x)) # still a character

x <- factor(LETTERS)
as.na(x)        # levels are kept
class(as.na(x)) # still a factor

x <- data.frame(x = 1:3, y = 2:4)
as.na(x)
dim(as.na(x))

x <- matrix(1:6, 2, 3)
attr(x, "today") <- Sys.Date()
as.na(x)        # attributes are kept

}
