% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concat.R
\name{concat}
\alias{concat}
\alias{concat0}
\alias{concat_}
\title{String concatenation}
\usage{
concat(..., sep = " ", na.rm = TRUE)

concat0(..., na.rm = TRUE)

concat_(..., na.rm = TRUE)
}
\arguments{
\item{...}{One or more objects, to be converted to character vectors 
and concatenated.}

\item{sep}{character. The character to use to separate the result.}

\item{na.rm}{logical. If \code{TRUE} (the default), missing values 
are removed before concatenation.}
}
\value{
Always a character value (vector of length \code{1}).
}
\description{
The function \code{concat} 
concatenates character vectors all together. 

\code{concat0(.)} is a wrapper for \code{concat(., sep = "")}. 
\code{concat_(.)} is a wrapper for \code{concat(., sep = "_")}.
}
\examples{
v <- c("Florence", "Julie", "Angela")
concat0(v)
concat_(v)
concat(v, sep = "^^")
concat0(c("a", "b"), c(1, NA, 3), NA)
concat(c(NA, NA))
concat(c(NA, NA), na.rm = FALSE) # usually not desirable

}
\seealso{
\code{\link[base]{paste}}.
}

