% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrQW_x_quantile.R
\name{quantile.lcens}
\alias{quantile.lcens}
\alias{quantile.mcens}
\alias{quantile.qw}
\title{Sample Quantiles}
\usage{
\method{quantile}{lcens}(
  x,
  probs = seq(0, 1, 0.25),
  na.rm = FALSE,
  names = TRUE,
  method = "flipped K-M",
  type = 2,
  alpha = 0.4,
  ...
)

\method{quantile}{mcens}(
  x,
  probs = seq(0, 1, 0.25),
  na.rm = FALSE,
  names = TRUE,
  method = "flipped K-M",
  type = 2,
  alpha = 0.4,
  ...
)

\method{quantile}{qw}(
  x,
  probs = seq(0, 1, 0.25),
  na.rm = FALSE,
  names = TRUE,
  method = "flipped K-M",
  type = 2,
  alpha = 0.4,
  ...
)
}
\arguments{
\item{x}{an object of a censored-data class whose sample quantiles are
wanted.  \code{NA} and \code{NaN} values are not allowed unless \code{na.rm}
is \code{TRUE}.}

\item{probs}{numeric vector of probabilities with values in [0,1].}

\item{na.rm}{logical; if \code{TRUE}, any \code{NA} and \code{NaN}s are
removed from \code{x} before the quantiles are computed.}

\item{names}{logical; if true, the result has a names attribute.}

\item{method}{the method to use for computing quantiles. See \bold{Details}.}

\item{type}{an integer between 1 and 9 selecting one of the nine quantile
algorithms described in \code{\link{quantile}}.}

\item{alpha}{the offset fraction to be used, depending on \code{method};
typically in [0, 0.5].}

\item{\dots}{not used, required for other methods.}
}
\value{
An optionally named vector of the requested probabilities. The names
of values that would be left-censored are marked with "*."
}
\description{
Computes sample or estimated quantiles corresponding to the given probabilities:
methods for "lcens," "mcens," and "qw" data.
The smallest observation (censored or uncensored) corresponds
to a probability of 0 and the largest to a probability of 1.
}
\details{
The methods available in the current version are "flipped K-M," "log ROS,"
"ROS," "log MLE," and "MLE." The method "flipped K-M" produces quantiles
using the Kaplan-Meier method on flipped data described by Helsel (2012). The
methods "log ROS" and "log MLE" are described by Helsel, 2012 and Helsel and
Cohn (1988).  The methods "ROS" and "MLE" are similar to "log ROS" and "log
MLE" except that no log- and back-transforms are made on the data.
}
\examples{

set.seed(28)
Xu <- rnorm(23)
quantile(as.lcens(Xu, 0)) 

}
\references{
Helsel, D.R. 2012, Statistics for censored environmental data 
using Minitab and R: New York, Wiley, 324 p.\cr
Helsel, D.R. and Cohn, T.A., 1988, Estimation of descriptive statistics for
multiply censored water quality data: Water Resources Research v. 24, n.
12, pp. 1997-2004
}
\seealso{
\code{\link{quantile}}
}
\keyword{internal}
\keyword{univar}
