% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrQW_x_imputeLessThans.R
\name{imputeLessThans}
\alias{imputeLessThans}
\alias{imputeLessThans.default}
\alias{imputeLessThans.data.frame}
\title{Impute Censored Values}
\usage{
imputeLessThans(
  ...,
  type = c("MLE", "robust"),
  initial = c("complete.obs", "multRepl")
)

\method{imputeLessThans}{default}(
  ...,
  type = c("MLE", "robust"),
  initial = c("complete.obs", "multRepl")
)

\method{imputeLessThans}{data.frame}(
  ...,
  group = NULL,
  type = c("MLE", "robust"),
  initial = c("complete.obs", "multRepl")
)
}
\arguments{
\item{\dots}{either a data frame that contains columns of class "qw" or any combination of
individual vectors of class "numeric," "lcens," or "qw." Missing values are
removed before processing.}

\item{type}{the type of estimate, "MLE" for maximum likelihood estimates, or "robust"
for robust estimation methods. See \code{\link[zCompositions]{lrEM}} for details.}

\item{initial}{the method to use for the initial log-ratio covariance matrix, either
"complete.obs" that uses only the rows with no censored data to construct the matrix, or
"multRepl" that uses simple substitution of censored values to compute the matrix.
See \code{\link[zCompositions]{lrEM}} for details.}

\item{group}{character string, the name of the column in the data frame to indicate
a group for imputation. See \bold{Details}}
}
\value{
A data frame containing the original data with imputed censored values.
}
\description{
Imputes substitute values for left-censored values using the expectation maximization method.
}
\details{
Imputation of left-censored data requires the assumption of multivariate 
log-normality for a single population. If the data represent samples from multiple
populations, then they should be identified by the \code{group} argument. The minimum size 
for any group is 3.
}
\seealso{
\code{\link[zCompositions]{lrEM}}
}
\keyword{internal}
