% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbnec.R
\name{ggbnec_data}
\alias{ggbnec_data}
\title{ggbnec_data}
\usage{
ggbnec_data(x, add_nec = TRUE, add_ecx = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{\link{bayesnecfit}} or
\code{\link{bayesmanecfit}}, as returned by function \code{\link{bnec}}.}

\item{add_nec}{Should NEC values be added to the plot? Defaults to TRUE.}

\item{add_ecx}{Should ECx values be added to the plot? Defaults to FALSE.}

\item{...}{Additional arguments to be passed to \code{\link{ecx}}. By
default, function \code{\link{ecx}} returns EC10.}
}
\value{
A \code{\link[base]{data.frame}}.
}
\description{
Creates the data.frame that feeds into the plotting function
\code{\link{ggbnec}}.
}
\examples{
\donttest{
library(bayesnec)
data(manec_example)

ggbnec_data(manec_example)
ggbnec_data(manec_example, add_ecx = TRUE, ecx_val = 50)
}

}
