% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_classes.R
\name{expand_manec}
\alias{expand_manec}
\title{expand_manec}
\usage{
expand_manec(
  object,
  x_range = NA,
  precision = 1000,
  sig_val = 0.01,
  loo_controls = list(method = "pseudobma")
)
}
\arguments{
\item{object}{a bayesmanecfit mod_fits output list, as returned by
\code{\link{bnec}} when more than one model is supplied.}

\item{x_range}{A range of x values over which to consider extracting ECx.}

\item{precision}{The length of the x vector used for posterior predictions,
and over which to extract ECx values. Large values will be slower but more
precise.}

\item{sig_val}{Probability value to use as the lower quantile to test
significance of the predicted posterior values
against the lowest observed concentration (assumed to be the control), to
estimate NEC as an interpolated NOEC value from smooth ECx curves.}

\item{loo_controls}{A named \code{\link[base]{list}} containing the desired
arguments to be passed on to \code{\link[loo]{loo_model_weights}}. It sets
the default wi_method to "pseudobma". See help documentation
?loo_model_weights from package loo.}
}
\value{
A list of model statistical output derived from the input model list
}
\description{
Extracts a range of statistics from a list of bayesnecfit model fits.
}
