% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.bayesianVARs_bvar}
\alias{plot.bayesianVARs_bvar}
\title{Plot method for bayesianVARs_bvar}
\usage{
\method{plot}{bayesianVARs_bvar}(
  x,
  predictions = NULL,
  quantiles = c(0.05, 0.5, 0.95),
  dates = NULL,
  n_col = 1,
  ...
)
}
\arguments{
\item{x}{An object of class \code{bayesianVARs_bvar} obtained via \code{\link[=bvar]{bvar()}}.}

\item{predictions}{Optional array of out of sample predictions, e.g. obtained
via \code{\link[=predict.bayesianVARs_bvar]{predict.bayesianVARs_bvar()}}.}

\item{quantiles}{numeric vector indicating which quantiles to plot.}

\item{dates}{optional vector of dates for labelling the x-axis. The default
values is \code{NULL}; in this case, the axis will be labeled with numbers.}

\item{n_col}{integer indicating the number of columns to use for plotting.}

\item{...}{Currently ignored!}
}
\value{
Returns \code{x} invisibly.
}
\description{
Visualization of in-sample fit. Can also be used to display prediction
intervals of future values.
}
\examples{
# Access a subset of the usmacro_growth dataset
data <- usmacro_growth[,c("GDPC1", "CPIAUCSL", "FEDFUNDS")]

# Estimate a model
mod <- bvar(data, sv_keep = "all", quiet = TRUE)

# Simulate from posterior predictive
predictions <- predict(mod, ahead = 1:3)

# Visualize
plot(mod, predictions = predictions)
}
\seealso{
Other plotting \code{\link[=plot.bayesianVARs_fitted]{plot.bayesianVARs_fitted()}},
\code{\link[=plot.bayesianVARs_predict]{plot.bayesianVARs_predict()}}, \code{\link[=pairs.bayesianVARs_predict]{pairs.bayesianVARs_predict()}},
\code{\link[=posterior_heatmap]{posterior_heatmap()}}.
}
