// Generated by rstantools.  Do not edit by hand.

/*
    Bforecast is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Bforecast is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Bforecast.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_ets_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_ets");
    reader.add_event(250, 248, "end", "model_ets");
    return reader;
}
template <typename T0__>
typename boost::math::tools::promote_args<T0__>::type
Jpv(const T0__& v, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 3;
        local_scalar_t__ y(DUMMY_VAR__);
        (void) y;  // dummy to suppress unused var warning
        stan::math::initialize(y, DUMMY_VAR__);
        stan::math::fill(y, DUMMY_VAR__);
        current_statement_begin__ = 4;
        stan::math::assign(y, ((trigamma((v / 2)) - trigamma(((v + 1) / 2))) - ((2 * (v + 3)) / ((v * (v + 1)) * (v + 1)))));
        current_statement_begin__ = 5;
        stan::math::assign(y, ((v / (v + 3)) * y));
        current_statement_begin__ = 6;
        return stan::math::promote_scalar<fun_return_scalar_t__>(stan::math::sqrt(y));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct Jpv_functor__ {
    template <typename T0__>
        typename boost::math::tools::promote_args<T0__>::type
    operator()(const T0__& v, std::ostream* pstream__) const {
        return Jpv(v, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_ets
  : public stan::model::model_base_crtp<model_ets> {
private:
        int n;
        int d1;
        matrix_d xreg;
        int period;
        vector_d y;
        int is_td;
        int is_dp;
        int is_ss;
        int genT;
        vector_d prior_sigma0;
        vector_d prior_dfv;
        vector_d prior_level;
        vector_d prior_trend;
        vector_d prior_damped;
        vector_d prior_seasonal;
        matrix_d prior_breg;
        vector_d prior_level1;
        vector_d prior_trend1;
        vector_d prior_seasonal1;
        int m;
public:
    model_ets(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_ets(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_ets_namespace::model_ets";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 10;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            check_greater_or_equal(function__, "n", n, 0);
            current_statement_begin__ = 11;
            context__.validate_dims("data initialization", "d1", "int", context__.to_vec());
            d1 = int(0);
            vals_i__ = context__.vals_i("d1");
            pos__ = 0;
            d1 = vals_i__[pos__++];
            check_greater_or_equal(function__, "d1", d1, 0);
            current_statement_begin__ = 12;
            validate_non_negative_index("xreg", "n", n);
            validate_non_negative_index("xreg", "d1", d1);
            context__.validate_dims("data initialization", "xreg", "matrix_d", context__.to_vec(n,d1));
            xreg = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, d1);
            vals_r__ = context__.vals_r("xreg");
            pos__ = 0;
            size_t xreg_j_2_max__ = d1;
            size_t xreg_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < xreg_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < xreg_j_1_max__; ++j_1__) {
                    xreg(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 13;
            context__.validate_dims("data initialization", "period", "int", context__.to_vec());
            period = int(0);
            vals_i__ = context__.vals_i("period");
            pos__ = 0;
            period = vals_i__[pos__++];
            check_greater_or_equal(function__, "period", period, 0);
            current_statement_begin__ = 14;
            validate_non_negative_index("y", "n", n);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(n));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 16;
            context__.validate_dims("data initialization", "is_td", "int", context__.to_vec());
            is_td = int(0);
            vals_i__ = context__.vals_i("is_td");
            pos__ = 0;
            is_td = vals_i__[pos__++];
            check_greater_or_equal(function__, "is_td", is_td, 0);
            check_less_or_equal(function__, "is_td", is_td, 1);
            current_statement_begin__ = 17;
            context__.validate_dims("data initialization", "is_dp", "int", context__.to_vec());
            is_dp = int(0);
            vals_i__ = context__.vals_i("is_dp");
            pos__ = 0;
            is_dp = vals_i__[pos__++];
            check_greater_or_equal(function__, "is_dp", is_dp, 0);
            check_less_or_equal(function__, "is_dp", is_dp, 1);
            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "is_ss", "int", context__.to_vec());
            is_ss = int(0);
            vals_i__ = context__.vals_i("is_ss");
            pos__ = 0;
            is_ss = vals_i__[pos__++];
            check_greater_or_equal(function__, "is_ss", is_ss, 0);
            check_less_or_equal(function__, "is_ss", is_ss, 1);
            current_statement_begin__ = 19;
            context__.validate_dims("data initialization", "genT", "int", context__.to_vec());
            genT = int(0);
            vals_i__ = context__.vals_i("genT");
            pos__ = 0;
            genT = vals_i__[pos__++];
            check_greater_or_equal(function__, "genT", genT, 0);
            check_less_or_equal(function__, "genT", genT, 1);
            current_statement_begin__ = 21;
            validate_non_negative_index("prior_sigma0", "4", 4);
            context__.validate_dims("data initialization", "prior_sigma0", "vector_d", context__.to_vec(4));
            prior_sigma0 = Eigen::Matrix<double, Eigen::Dynamic, 1>(4);
            vals_r__ = context__.vals_r("prior_sigma0");
            pos__ = 0;
            size_t prior_sigma0_j_1_max__ = 4;
            for (size_t j_1__ = 0; j_1__ < prior_sigma0_j_1_max__; ++j_1__) {
                prior_sigma0(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 22;
            validate_non_negative_index("prior_dfv", "4", 4);
            context__.validate_dims("data initialization", "prior_dfv", "vector_d", context__.to_vec(4));
            prior_dfv = Eigen::Matrix<double, Eigen::Dynamic, 1>(4);
            vals_r__ = context__.vals_r("prior_dfv");
            pos__ = 0;
            size_t prior_dfv_j_1_max__ = 4;
            for (size_t j_1__ = 0; j_1__ < prior_dfv_j_1_max__; ++j_1__) {
                prior_dfv(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 23;
            validate_non_negative_index("prior_level", "4", 4);
            context__.validate_dims("data initialization", "prior_level", "vector_d", context__.to_vec(4));
            prior_level = Eigen::Matrix<double, Eigen::Dynamic, 1>(4);
            vals_r__ = context__.vals_r("prior_level");
            pos__ = 0;
            size_t prior_level_j_1_max__ = 4;
            for (size_t j_1__ = 0; j_1__ < prior_level_j_1_max__; ++j_1__) {
                prior_level(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 24;
            validate_non_negative_index("prior_trend", "4", 4);
            context__.validate_dims("data initialization", "prior_trend", "vector_d", context__.to_vec(4));
            prior_trend = Eigen::Matrix<double, Eigen::Dynamic, 1>(4);
            vals_r__ = context__.vals_r("prior_trend");
            pos__ = 0;
            size_t prior_trend_j_1_max__ = 4;
            for (size_t j_1__ = 0; j_1__ < prior_trend_j_1_max__; ++j_1__) {
                prior_trend(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 25;
            validate_non_negative_index("prior_damped", "4", 4);
            context__.validate_dims("data initialization", "prior_damped", "vector_d", context__.to_vec(4));
            prior_damped = Eigen::Matrix<double, Eigen::Dynamic, 1>(4);
            vals_r__ = context__.vals_r("prior_damped");
            pos__ = 0;
            size_t prior_damped_j_1_max__ = 4;
            for (size_t j_1__ = 0; j_1__ < prior_damped_j_1_max__; ++j_1__) {
                prior_damped(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 26;
            validate_non_negative_index("prior_seasonal", "4", 4);
            context__.validate_dims("data initialization", "prior_seasonal", "vector_d", context__.to_vec(4));
            prior_seasonal = Eigen::Matrix<double, Eigen::Dynamic, 1>(4);
            vals_r__ = context__.vals_r("prior_seasonal");
            pos__ = 0;
            size_t prior_seasonal_j_1_max__ = 4;
            for (size_t j_1__ = 0; j_1__ < prior_seasonal_j_1_max__; ++j_1__) {
                prior_seasonal(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 27;
            validate_non_negative_index("prior_breg", "d1", d1);
            validate_non_negative_index("prior_breg", "4", 4);
            context__.validate_dims("data initialization", "prior_breg", "matrix_d", context__.to_vec(d1,4));
            prior_breg = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(d1, 4);
            vals_r__ = context__.vals_r("prior_breg");
            pos__ = 0;
            size_t prior_breg_j_2_max__ = 4;
            size_t prior_breg_j_1_max__ = d1;
            for (size_t j_2__ = 0; j_2__ < prior_breg_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_breg_j_1_max__; ++j_1__) {
                    prior_breg(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 29;
            validate_non_negative_index("prior_level1", "4", 4);
            context__.validate_dims("data initialization", "prior_level1", "vector_d", context__.to_vec(4));
            prior_level1 = Eigen::Matrix<double, Eigen::Dynamic, 1>(4);
            vals_r__ = context__.vals_r("prior_level1");
            pos__ = 0;
            size_t prior_level1_j_1_max__ = 4;
            for (size_t j_1__ = 0; j_1__ < prior_level1_j_1_max__; ++j_1__) {
                prior_level1(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 30;
            validate_non_negative_index("prior_trend1", "4", 4);
            context__.validate_dims("data initialization", "prior_trend1", "vector_d", context__.to_vec(4));
            prior_trend1 = Eigen::Matrix<double, Eigen::Dynamic, 1>(4);
            vals_r__ = context__.vals_r("prior_trend1");
            pos__ = 0;
            size_t prior_trend1_j_1_max__ = 4;
            for (size_t j_1__ = 0; j_1__ < prior_trend1_j_1_max__; ++j_1__) {
                prior_trend1(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 31;
            validate_non_negative_index("prior_seasonal1", "4", 4);
            context__.validate_dims("data initialization", "prior_seasonal1", "vector_d", context__.to_vec(4));
            prior_seasonal1 = Eigen::Matrix<double, Eigen::Dynamic, 1>(4);
            vals_r__ = context__.vals_r("prior_seasonal1");
            pos__ = 0;
            size_t prior_seasonal1_j_1_max__ = 4;
            for (size_t j_1__ = 0; j_1__ < prior_seasonal1_j_1_max__; ++j_1__) {
                prior_seasonal1(j_1__) = vals_r__[pos__++];
            }
            // initialize transformed data variables
            current_statement_begin__ = 34;
            m = int(0);
            stan::math::fill(m, std::numeric_limits<int>::min());
            stan::math::assign(m,period);
            // execute transformed data statements
            current_statement_begin__ = 35;
            if (as_bool(logical_eq(is_ss, 0))) {
                current_statement_begin__ = 35;
                stan::math::assign(m, 1);
            }
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 38;
            validate_non_negative_index("breg", "d1", d1);
            num_params_r__ += d1;
            current_statement_begin__ = 39;
            num_params_r__ += 1;
            current_statement_begin__ = 40;
            num_params_r__ += 1;
            current_statement_begin__ = 41;
            validate_non_negative_index("trend", "is_td", is_td);
            num_params_r__ += is_td;
            current_statement_begin__ = 42;
            validate_non_negative_index("damped", "is_dp", is_dp);
            num_params_r__ += is_dp;
            current_statement_begin__ = 43;
            validate_non_negative_index("seasonal", "is_ss", is_ss);
            num_params_r__ += is_ss;
            current_statement_begin__ = 44;
            validate_non_negative_index("v", "(genT * 1)", (genT * 1));
            num_params_r__ += (genT * 1);
            current_statement_begin__ = 45;
            validate_non_negative_index("lambda", "(genT * 1)", (genT * 1));
            num_params_r__ += (genT * 1);
            current_statement_begin__ = 48;
            num_params_r__ += 1;
            current_statement_begin__ = 49;
            validate_non_negative_index("trend1", "is_td", is_td);
            num_params_r__ += is_td;
            current_statement_begin__ = 50;
            validate_non_negative_index("seasonal1", "(m * is_ss)", (m * is_ss));
            num_params_r__ += (m * is_ss);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_ets() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 38;
        if (!(context__.contains_r("breg")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable breg missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("breg");
        pos__ = 0U;
        validate_non_negative_index("breg", "d1", d1);
        context__.validate_dims("parameter initialization", "breg", "vector_d", context__.to_vec(d1));
        Eigen::Matrix<double, Eigen::Dynamic, 1> breg(d1);
        size_t breg_j_1_max__ = d1;
        for (size_t j_1__ = 0; j_1__ < breg_j_1_max__; ++j_1__) {
            breg(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(breg);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable breg: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 39;
        if (!(context__.contains_r("sigma0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma0");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma0", "double", context__.to_vec());
        double sigma0(0);
        sigma0 = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 40;
        if (!(context__.contains_r("level")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable level missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("level");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "level", "double", context__.to_vec());
        double level(0);
        level = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 1, level);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable level: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 41;
        if (!(context__.contains_r("trend")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable trend missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("trend");
        pos__ = 0U;
        validate_non_negative_index("trend", "is_td", is_td);
        context__.validate_dims("parameter initialization", "trend", "vector_d", context__.to_vec(is_td));
        Eigen::Matrix<double, Eigen::Dynamic, 1> trend(is_td);
        size_t trend_j_1_max__ = is_td;
        for (size_t j_1__ = 0; j_1__ < trend_j_1_max__; ++j_1__) {
            trend(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 1, trend);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable trend: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 42;
        if (!(context__.contains_r("damped")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable damped missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("damped");
        pos__ = 0U;
        validate_non_negative_index("damped", "is_dp", is_dp);
        context__.validate_dims("parameter initialization", "damped", "vector_d", context__.to_vec(is_dp));
        Eigen::Matrix<double, Eigen::Dynamic, 1> damped(is_dp);
        size_t damped_j_1_max__ = is_dp;
        for (size_t j_1__ = 0; j_1__ < damped_j_1_max__; ++j_1__) {
            damped(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 1, damped);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable damped: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 43;
        if (!(context__.contains_r("seasonal")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable seasonal missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("seasonal");
        pos__ = 0U;
        validate_non_negative_index("seasonal", "is_ss", is_ss);
        context__.validate_dims("parameter initialization", "seasonal", "vector_d", context__.to_vec(is_ss));
        Eigen::Matrix<double, Eigen::Dynamic, 1> seasonal(is_ss);
        size_t seasonal_j_1_max__ = is_ss;
        for (size_t j_1__ = 0; j_1__ < seasonal_j_1_max__; ++j_1__) {
            seasonal(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 1, seasonal);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable seasonal: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 44;
        if (!(context__.contains_r("v")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable v missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("v");
        pos__ = 0U;
        validate_non_negative_index("v", "(genT * 1)", (genT * 1));
        context__.validate_dims("parameter initialization", "v", "vector_d", context__.to_vec((genT * 1)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> v((genT * 1));
        size_t v_j_1_max__ = (genT * 1);
        for (size_t j_1__ = 0; j_1__ < v_j_1_max__; ++j_1__) {
            v(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(2.01, v);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable v: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 45;
        if (!(context__.contains_r("lambda")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lambda missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lambda");
        pos__ = 0U;
        validate_non_negative_index("lambda", "(genT * 1)", (genT * 1));
        context__.validate_dims("parameter initialization", "lambda", "vector_d", context__.to_vec((genT * 1)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda((genT * 1));
        size_t lambda_j_1_max__ = (genT * 1);
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            lambda(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(1, lambda);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lambda: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 48;
        if (!(context__.contains_r("level1")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable level1 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("level1");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "level1", "double", context__.to_vec());
        double level1(0);
        level1 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(level1);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable level1: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 49;
        if (!(context__.contains_r("trend1")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable trend1 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("trend1");
        pos__ = 0U;
        validate_non_negative_index("trend1", "is_td", is_td);
        context__.validate_dims("parameter initialization", "trend1", "vector_d", context__.to_vec(is_td));
        Eigen::Matrix<double, Eigen::Dynamic, 1> trend1(is_td);
        size_t trend1_j_1_max__ = is_td;
        for (size_t j_1__ = 0; j_1__ < trend1_j_1_max__; ++j_1__) {
            trend1(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(trend1);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable trend1: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 50;
        if (!(context__.contains_r("seasonal1")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable seasonal1 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("seasonal1");
        pos__ = 0U;
        validate_non_negative_index("seasonal1", "(m * is_ss)", (m * is_ss));
        context__.validate_dims("parameter initialization", "seasonal1", "vector_d", context__.to_vec((m * is_ss)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> seasonal1((m * is_ss));
        size_t seasonal1_j_1_max__ = (m * is_ss);
        for (size_t j_1__ = 0; j_1__ < seasonal1_j_1_max__; ++j_1__) {
            seasonal1(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(seasonal1);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable seasonal1: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 38;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> breg;
            (void) breg;  // dummy to suppress unused var warning
            if (jacobian__)
                breg = in__.vector_constrain(d1, lp__);
            else
                breg = in__.vector_constrain(d1);
            current_statement_begin__ = 39;
            local_scalar_t__ sigma0;
            (void) sigma0;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma0 = in__.scalar_lb_constrain(0, lp__);
            else
                sigma0 = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 40;
            local_scalar_t__ level;
            (void) level;  // dummy to suppress unused var warning
            if (jacobian__)
                level = in__.scalar_lub_constrain(0, 1, lp__);
            else
                level = in__.scalar_lub_constrain(0, 1);
            current_statement_begin__ = 41;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> trend;
            (void) trend;  // dummy to suppress unused var warning
            if (jacobian__)
                trend = in__.vector_lub_constrain(0, 1, is_td, lp__);
            else
                trend = in__.vector_lub_constrain(0, 1, is_td);
            current_statement_begin__ = 42;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> damped;
            (void) damped;  // dummy to suppress unused var warning
            if (jacobian__)
                damped = in__.vector_lub_constrain(0, 1, is_dp, lp__);
            else
                damped = in__.vector_lub_constrain(0, 1, is_dp);
            current_statement_begin__ = 43;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> seasonal;
            (void) seasonal;  // dummy to suppress unused var warning
            if (jacobian__)
                seasonal = in__.vector_lub_constrain(0, 1, is_ss, lp__);
            else
                seasonal = in__.vector_lub_constrain(0, 1, is_ss);
            current_statement_begin__ = 44;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> v;
            (void) v;  // dummy to suppress unused var warning
            if (jacobian__)
                v = in__.vector_lb_constrain(2.01, (genT * 1), lp__);
            else
                v = in__.vector_lb_constrain(2.01, (genT * 1));
            current_statement_begin__ = 45;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda;
            (void) lambda;  // dummy to suppress unused var warning
            if (jacobian__)
                lambda = in__.vector_lb_constrain(1, (genT * 1), lp__);
            else
                lambda = in__.vector_lb_constrain(1, (genT * 1));
            current_statement_begin__ = 48;
            local_scalar_t__ level1;
            (void) level1;  // dummy to suppress unused var warning
            if (jacobian__)
                level1 = in__.scalar_constrain(lp__);
            else
                level1 = in__.scalar_constrain();
            current_statement_begin__ = 49;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> trend1;
            (void) trend1;  // dummy to suppress unused var warning
            if (jacobian__)
                trend1 = in__.vector_constrain(is_td, lp__);
            else
                trend1 = in__.vector_constrain(is_td);
            current_statement_begin__ = 50;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> seasonal1;
            (void) seasonal1;  // dummy to suppress unused var warning
            if (jacobian__)
                seasonal1 = in__.vector_constrain((m * is_ss), lp__);
            else
                seasonal1 = in__.vector_constrain((m * is_ss));
            // transformed parameters
            current_statement_begin__ = 53;
            validate_non_negative_index("mu", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu(n);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 54;
            validate_non_negative_index("epsilon", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> epsilon(n);
            stan::math::initialize(epsilon, DUMMY_VAR__);
            stan::math::fill(epsilon, DUMMY_VAR__);
            current_statement_begin__ = 55;
            validate_non_negative_index("l", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> l(n);
            stan::math::initialize(l, DUMMY_VAR__);
            stan::math::fill(l, DUMMY_VAR__);
            current_statement_begin__ = 56;
            validate_non_negative_index("b", "(is_td * n)", (is_td * n));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> b((is_td * n));
            stan::math::initialize(b, DUMMY_VAR__);
            stan::math::fill(b, DUMMY_VAR__);
            current_statement_begin__ = 57;
            validate_non_negative_index("s", "(is_ss * n)", (is_ss * n));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> s((is_ss * n));
            stan::math::initialize(s, DUMMY_VAR__);
            stan::math::fill(s, DUMMY_VAR__);
            current_statement_begin__ = 58;
            validate_non_negative_index("v1", "(genT * 1)", (genT * 1));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> v1((genT * 1));
            stan::math::initialize(v1, DUMMY_VAR__);
            stan::math::fill(v1, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 61;
            if (as_bool(logical_gt(d1, 0))) {
                current_statement_begin__ = 61;
                stan::math::assign(mu, multiply(xreg, breg));
            } else {
                current_statement_begin__ = 62;
                stan::math::assign(mu, rep_vector(0, n));
            }
            current_statement_begin__ = 65;
            stan::model::assign(l, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        level1, 
                        "assigning variable l");
            current_statement_begin__ = 65;
            stan::model::assign(mu, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), "mu") + level1), 
                        "assigning variable mu");
            current_statement_begin__ = 66;
            stan::model::assign(epsilon, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        (get_base1(y, 1, "y", 1) - get_base1(mu, 1, "mu", 1)), 
                        "assigning variable epsilon");
            current_statement_begin__ = 67;
            if (as_bool(logical_eq(is_td, 1))) {
                current_statement_begin__ = 67;
                stan::model::assign(b, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            get_base1(trend1, 1, "trend1", 1), 
                            "assigning variable b");
            }
            current_statement_begin__ = 68;
            if (as_bool(logical_eq(is_ss, 1))) {
                current_statement_begin__ = 68;
                for (int i = 1; i <= m; ++i) {
                    current_statement_begin__ = 68;
                    stan::model::assign(s, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(seasonal1, i, "seasonal1", 1), 
                                "assigning variable s");
                }
            }
            current_statement_begin__ = 71;
            if (as_bool(logical_eq(genT, 1))) {
                current_statement_begin__ = 71;
                stan::model::assign(v1, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            stan::math::sqrt((((get_base1(v, 1, "v", 1) - 2) * get_base1(lambda, 1, "lambda", 1)) / get_base1(v, 1, "v", 1))), 
                            "assigning variable v1");
            }
            current_statement_begin__ = 75;
            for (int i = 2; i <= n; ++i) {
                current_statement_begin__ = 78;
                stan::model::assign(l, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((level * (get_base1(y, i, "y", 1) - get_base1(mu, i, "mu", 1))) + ((1 - level) * get_base1(l, (i - 1), "l", 1))), 
                            "assigning variable l");
                current_statement_begin__ = 79;
                if (as_bool((primitive_value(logical_eq(is_ss, 1)) && primitive_value(logical_gt(i, m))))) {
                    current_statement_begin__ = 79;
                    stan::model::assign(l, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(l, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "l") + (-(level) * get_base1(s, (i - m), "s", 1))), 
                                "assigning variable l");
                }
                current_statement_begin__ = 81;
                stan::model::assign(mu, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "mu") + get_base1(l, (i - 1), "l", 1)), 
                            "assigning variable mu");
                current_statement_begin__ = 84;
                if (as_bool(logical_eq(is_td, 1))) {
                    current_statement_begin__ = 86;
                    if (as_bool(logical_eq(is_dp, 1))) {
                        current_statement_begin__ = 86;
                        stan::model::assign(b, 
                                    stan::model::cons_list(stan::model::index_uni((i - 1)), stan::model::nil_index_list()), 
                                    (get_base1(damped, 1, "damped", 1) * get_base1(b, (i - 1), "b", 1)), 
                                    "assigning variable b");
                    }
                    current_statement_begin__ = 87;
                    stan::model::assign(b, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((get_base1(trend, 1, "trend", 1) * (get_base1(l, i, "l", 1) - get_base1(l, (i - 1), "l", 1))) + ((1 - get_base1(trend, 1, "trend", 1)) * get_base1(b, (i - 1), "b", 1))), 
                                "assigning variable b");
                    current_statement_begin__ = 88;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "mu") + get_base1(b, (i - 1), "b", 1)), 
                                "assigning variable mu");
                }
                current_statement_begin__ = 92;
                if (as_bool(logical_eq(is_ss, 1))) {
                    current_statement_begin__ = 93;
                    if (as_bool(logical_gt(i, m))) {
                        current_statement_begin__ = 94;
                        stan::model::assign(s, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((get_base1(seasonal, 1, "seasonal", 1) * (get_base1(y, i, "y", 1) - get_base1(l, i, "l", 1))) + ((1 - get_base1(seasonal, 1, "seasonal", 1)) * get_base1(s, (i - m), "s", 1))), 
                                    "assigning variable s");
                        current_statement_begin__ = 95;
                        if (as_bool(logical_eq(is_td, 1))) {
                            current_statement_begin__ = 95;
                            stan::model::assign(s, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (stan::model::rvalue(s, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "s") + (-(get_base1(seasonal, 1, "seasonal", 1)) * get_base1(b, i, "b", 1))), 
                                        "assigning variable s");
                        }
                        current_statement_begin__ = 96;
                        stan::model::assign(mu, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "mu") + get_base1(s, (i - m), "s", 1)), 
                                    "assigning variable mu");
                    }
                }
                current_statement_begin__ = 100;
                stan::model::assign(epsilon, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(y, i, "y", 1) - get_base1(mu, i, "mu", 1)), 
                            "assigning variable epsilon");
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 53;
            size_t mu_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(mu(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: mu" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 54;
            size_t epsilon_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < epsilon_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(epsilon(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: epsilon" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable epsilon: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 55;
            size_t l_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < l_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(l(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: l" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable l: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 56;
            size_t b_j_1_max__ = (is_td * n);
            for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(b(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: b" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable b: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 57;
            size_t s_j_1_max__ = (is_ss * n);
            for (size_t j_1__ = 0; j_1__ < s_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(s(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: s" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable s: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 58;
            size_t v1_j_1_max__ = (genT * 1);
            for (size_t j_1__ = 0; j_1__ < v1_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(v1(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: v1" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable v1: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "v1", v1, 1);
            // model body
            current_statement_begin__ = 107;
            if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 1))) {
                current_statement_begin__ = 107;
                lp_accum__.add(normal_log(sigma0, get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 2))) {
                current_statement_begin__ = 108;
                lp_accum__.add(beta_log(sigma0, get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 3))) {
                current_statement_begin__ = 109;
                lp_accum__.add(uniform_log(sigma0, get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 4))) {
                current_statement_begin__ = 110;
                lp_accum__.add(student_t_log(sigma0, get_base1(prior_sigma0, 3, "prior_sigma0", 1), get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 5))) {
                current_statement_begin__ = 111;
                lp_accum__.add(cauchy_log(sigma0, get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 6))) {
                current_statement_begin__ = 112;
                lp_accum__.add(inv_gamma_log(sigma0, get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 7))) {
                current_statement_begin__ = 113;
                lp_accum__.add(inv_chi_square_log(sigma0, get_base1(prior_sigma0, 3, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 8))) {
                current_statement_begin__ = 114;
                lp_accum__.add(-(stan::math::log(sigma0)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 9))) {
                current_statement_begin__ = 115;
                lp_accum__.add(gamma_log(sigma0, get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 10))) {
                current_statement_begin__ = 116;
                lp_accum__.add(exponential_log(sigma0, get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 11))) {
                current_statement_begin__ = 117;
                lp_accum__.add(chi_square_log(sigma0, get_base1(prior_sigma0, 3, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 12))) {
                current_statement_begin__ = 118;
                lp_accum__.add(double_exponential_log(sigma0, get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            }
            current_statement_begin__ = 121;
            if (as_bool(logical_gt(d1, 0))) {
                current_statement_begin__ = 122;
                for (int i = 1; i <= d1; ++i) {
                    current_statement_begin__ = 123;
                    if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 1))) {
                        current_statement_begin__ = 123;
                        lp_accum__.add(normal_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 2))) {
                        current_statement_begin__ = 124;
                        lp_accum__.add(beta_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 3))) {
                        current_statement_begin__ = 125;
                        lp_accum__.add(uniform_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 4))) {
                        current_statement_begin__ = 126;
                        lp_accum__.add(student_t_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 3, "prior_breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 5))) {
                        current_statement_begin__ = 127;
                        lp_accum__.add(cauchy_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 6))) {
                        current_statement_begin__ = 128;
                        lp_accum__.add(inv_gamma_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 7))) {
                        current_statement_begin__ = 129;
                        lp_accum__.add(inv_chi_square_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 3, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 8))) {
                        current_statement_begin__ = 130;
                        lp_accum__.add(-(stan::math::log(sigma0)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 9))) {
                        current_statement_begin__ = 131;
                        lp_accum__.add(gamma_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 10))) {
                        current_statement_begin__ = 132;
                        lp_accum__.add(exponential_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 11))) {
                        current_statement_begin__ = 133;
                        lp_accum__.add(chi_square_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 3, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 12))) {
                        current_statement_begin__ = 134;
                        lp_accum__.add(double_exponential_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    }
                }
            }
            current_statement_begin__ = 138;
            if (as_bool(logical_eq(get_base1(prior_level, 4, "prior_level", 1), 1))) {
                current_statement_begin__ = 138;
                lp_accum__.add(normal_log(level, get_base1(prior_level, 1, "prior_level", 1), get_base1(prior_level, 2, "prior_level", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_level, 4, "prior_level", 1), 2))) {
                current_statement_begin__ = 139;
                lp_accum__.add(beta_log(level, get_base1(prior_level, 1, "prior_level", 1), get_base1(prior_level, 2, "prior_level", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_level, 4, "prior_level", 1), 3))) {
                current_statement_begin__ = 140;
                lp_accum__.add(uniform_log(level, get_base1(prior_level, 1, "prior_level", 1), get_base1(prior_level, 2, "prior_level", 1)));
            }
            current_statement_begin__ = 143;
            if (as_bool(logical_eq(get_base1(prior_level1, 4, "prior_level1", 1), 1))) {
                current_statement_begin__ = 143;
                lp_accum__.add(normal_log(level1, get_base1(prior_level1, 1, "prior_level1", 1), get_base1(prior_level1, 2, "prior_level1", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_level1, 4, "prior_level1", 1), 2))) {
                current_statement_begin__ = 144;
                lp_accum__.add(beta_log(level1, get_base1(prior_level1, 1, "prior_level1", 1), get_base1(prior_level1, 2, "prior_level1", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_level1, 4, "prior_level1", 1), 3))) {
                current_statement_begin__ = 145;
                lp_accum__.add(uniform_log(level1, get_base1(prior_level1, 1, "prior_level1", 1), get_base1(prior_level1, 2, "prior_level1", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_level1, 4, "prior_level1", 1), 4))) {
                current_statement_begin__ = 146;
                lp_accum__.add(student_t_log(level1, get_base1(prior_level1, 3, "prior_level1", 1), get_base1(prior_level1, 1, "prior_level1", 1), get_base1(prior_level1, 2, "prior_level1", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_level1, 4, "prior_level1", 1), 5))) {
                current_statement_begin__ = 147;
                lp_accum__.add(cauchy_log(level1, get_base1(prior_level1, 1, "prior_level1", 1), get_base1(prior_level1, 2, "prior_level1", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_level1, 4, "prior_level1", 1), 6))) {
                current_statement_begin__ = 148;
                lp_accum__.add(inv_gamma_log(level1, get_base1(prior_level1, 1, "prior_level1", 1), get_base1(prior_level1, 2, "prior_level1", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_level1, 4, "prior_level1", 1), 7))) {
                current_statement_begin__ = 149;
                lp_accum__.add(inv_chi_square_log(level1, get_base1(prior_level1, 3, "prior_level1", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_level1, 4, "prior_level1", 1), 8))) {
                current_statement_begin__ = 150;
                lp_accum__.add(-(stan::math::log(sigma0)));
            } else if (as_bool(logical_eq(get_base1(prior_level1, 4, "prior_level1", 1), 9))) {
                current_statement_begin__ = 151;
                lp_accum__.add(gamma_log(level1, get_base1(prior_level1, 1, "prior_level1", 1), get_base1(prior_level1, 2, "prior_level1", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_level1, 4, "prior_level1", 1), 10))) {
                current_statement_begin__ = 152;
                lp_accum__.add(exponential_log(level1, get_base1(prior_level1, 2, "prior_level1", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_level1, 4, "prior_level1", 1), 11))) {
                current_statement_begin__ = 153;
                lp_accum__.add(chi_square_log(level1, get_base1(prior_level1, 3, "prior_level1", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_level1, 4, "prior_level1", 1), 12))) {
                current_statement_begin__ = 154;
                lp_accum__.add(double_exponential_log(level1, get_base1(prior_level1, 1, "prior_level1", 1), get_base1(prior_level1, 2, "prior_level1", 1)));
            }
            current_statement_begin__ = 157;
            if (as_bool(logical_eq(is_td, 1))) {
                current_statement_begin__ = 158;
                if (as_bool(logical_eq(get_base1(prior_trend, 4, "prior_trend", 1), 1))) {
                    current_statement_begin__ = 158;
                    lp_accum__.add(normal_log(get_base1(trend, 1, "trend", 1), get_base1(prior_trend, 1, "prior_trend", 1), get_base1(prior_trend, 2, "prior_trend", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_trend, 4, "prior_trend", 1), 2))) {
                    current_statement_begin__ = 159;
                    lp_accum__.add(beta_log(get_base1(trend, 1, "trend", 1), get_base1(prior_trend, 1, "prior_trend", 1), get_base1(prior_trend, 2, "prior_trend", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_trend, 4, "prior_trend", 1), 3))) {
                    current_statement_begin__ = 160;
                    lp_accum__.add(uniform_log(get_base1(trend, 1, "trend", 1), get_base1(prior_trend, 1, "prior_trend", 1), get_base1(prior_trend, 2, "prior_trend", 1)));
                }
                current_statement_begin__ = 163;
                if (as_bool(logical_eq(get_base1(prior_trend1, 4, "prior_trend1", 1), 1))) {
                    current_statement_begin__ = 163;
                    lp_accum__.add(normal_log(trend1, get_base1(prior_trend1, 1, "prior_trend1", 1), get_base1(prior_trend1, 2, "prior_trend1", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_trend1, 4, "prior_trend1", 1), 2))) {
                    current_statement_begin__ = 164;
                    lp_accum__.add(beta_log(trend1, get_base1(prior_trend1, 1, "prior_trend1", 1), get_base1(prior_trend1, 2, "prior_trend1", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_trend1, 4, "prior_trend1", 1), 3))) {
                    current_statement_begin__ = 165;
                    lp_accum__.add(uniform_log(trend1, get_base1(prior_trend1, 1, "prior_trend1", 1), get_base1(prior_trend1, 2, "prior_trend1", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_trend1, 4, "prior_trend1", 1), 4))) {
                    current_statement_begin__ = 166;
                    lp_accum__.add(student_t_log(trend1, get_base1(prior_trend1, 3, "prior_trend1", 1), get_base1(prior_trend1, 1, "prior_trend1", 1), get_base1(prior_trend1, 2, "prior_trend1", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_trend1, 4, "prior_trend1", 1), 5))) {
                    current_statement_begin__ = 167;
                    lp_accum__.add(cauchy_log(trend1, get_base1(prior_trend1, 1, "prior_trend1", 1), get_base1(prior_trend1, 2, "prior_trend1", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_trend1, 4, "prior_trend1", 1), 6))) {
                    current_statement_begin__ = 168;
                    lp_accum__.add(inv_gamma_log(trend1, get_base1(prior_trend1, 1, "prior_trend1", 1), get_base1(prior_trend1, 2, "prior_trend1", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_trend1, 4, "prior_trend1", 1), 7))) {
                    current_statement_begin__ = 169;
                    lp_accum__.add(inv_chi_square_log(trend1, get_base1(prior_trend1, 3, "prior_trend1", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_trend1, 4, "prior_trend1", 1), 8))) {
                    current_statement_begin__ = 170;
                    lp_accum__.add(-(stan::math::log(sigma0)));
                } else if (as_bool(logical_eq(get_base1(prior_trend1, 4, "prior_trend1", 1), 9))) {
                    current_statement_begin__ = 171;
                    lp_accum__.add(gamma_log(trend1, get_base1(prior_trend1, 1, "prior_trend1", 1), get_base1(prior_trend1, 2, "prior_trend1", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_trend1, 4, "prior_trend1", 1), 10))) {
                    current_statement_begin__ = 172;
                    lp_accum__.add(exponential_log(trend1, get_base1(prior_trend1, 2, "prior_trend1", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_trend1, 4, "prior_trend1", 1), 11))) {
                    current_statement_begin__ = 173;
                    lp_accum__.add(chi_square_log(trend1, get_base1(prior_trend1, 3, "prior_trend1", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_trend1, 4, "prior_trend1", 1), 12))) {
                    current_statement_begin__ = 174;
                    lp_accum__.add(double_exponential_log(trend1, get_base1(prior_trend1, 1, "prior_trend1", 1), get_base1(prior_trend1, 2, "prior_trend1", 1)));
                }
            }
            current_statement_begin__ = 178;
            if (as_bool(logical_eq(is_dp, 1))) {
                current_statement_begin__ = 179;
                if (as_bool(logical_eq(get_base1(prior_damped, 4, "prior_damped", 1), 1))) {
                    current_statement_begin__ = 179;
                    lp_accum__.add(normal_log(get_base1(damped, 1, "damped", 1), get_base1(prior_damped, 1, "prior_damped", 1), get_base1(prior_damped, 2, "prior_damped", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_damped, 4, "prior_damped", 1), 2))) {
                    current_statement_begin__ = 180;
                    lp_accum__.add(beta_log(get_base1(damped, 1, "damped", 1), get_base1(prior_damped, 1, "prior_damped", 1), get_base1(prior_damped, 2, "prior_damped", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_damped, 4, "prior_damped", 1), 3))) {
                    current_statement_begin__ = 181;
                    lp_accum__.add(uniform_log(get_base1(damped, 1, "damped", 1), get_base1(prior_damped, 1, "prior_damped", 1), get_base1(prior_damped, 2, "prior_damped", 1)));
                }
            }
            current_statement_begin__ = 185;
            if (as_bool(logical_eq(is_ss, 1))) {
                current_statement_begin__ = 186;
                if (as_bool(logical_eq(get_base1(prior_seasonal, 4, "prior_seasonal", 1), 1))) {
                    current_statement_begin__ = 186;
                    lp_accum__.add(normal_log(get_base1(seasonal, 1, "seasonal", 1), get_base1(prior_seasonal, 1, "prior_seasonal", 1), get_base1(prior_seasonal, 2, "prior_seasonal", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_seasonal, 4, "prior_seasonal", 1), 2))) {
                    current_statement_begin__ = 187;
                    lp_accum__.add(beta_log(get_base1(seasonal, 1, "seasonal", 1), get_base1(prior_seasonal, 1, "prior_seasonal", 1), get_base1(prior_seasonal, 2, "prior_seasonal", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_seasonal, 4, "prior_seasonal", 1), 3))) {
                    current_statement_begin__ = 188;
                    lp_accum__.add(uniform_log(get_base1(seasonal, 1, "seasonal", 1), get_base1(prior_seasonal, 1, "prior_seasonal", 1), get_base1(prior_seasonal, 2, "prior_seasonal", 1)));
                }
                current_statement_begin__ = 191;
                if (as_bool(logical_eq(get_base1(prior_seasonal1, 4, "prior_seasonal1", 1), 1))) {
                    current_statement_begin__ = 191;
                    lp_accum__.add(normal_log(seasonal1, get_base1(prior_seasonal, 1, "prior_seasonal", 1), get_base1(prior_seasonal, 2, "prior_seasonal", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_seasonal1, 4, "prior_seasonal1", 1), 2))) {
                    current_statement_begin__ = 192;
                    lp_accum__.add(beta_log(seasonal1, get_base1(prior_seasonal1, 1, "prior_seasonal1", 1), get_base1(prior_seasonal1, 2, "prior_seasonal1", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_seasonal1, 4, "prior_seasonal1", 1), 3))) {
                    current_statement_begin__ = 193;
                    lp_accum__.add(uniform_log(seasonal1, get_base1(prior_seasonal1, 1, "prior_seasonal1", 1), get_base1(prior_seasonal1, 2, "prior_seasonal1", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_seasonal1, 4, "prior_seasonal1", 1), 4))) {
                    current_statement_begin__ = 194;
                    lp_accum__.add(student_t_log(seasonal1, get_base1(prior_seasonal1, 3, "prior_seasonal1", 1), get_base1(prior_seasonal1, 1, "prior_seasonal1", 1), get_base1(prior_seasonal1, 2, "prior_seasonal1", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_seasonal1, 4, "prior_seasonal1", 1), 5))) {
                    current_statement_begin__ = 195;
                    lp_accum__.add(cauchy_log(seasonal1, get_base1(prior_seasonal1, 1, "prior_seasonal1", 1), get_base1(prior_seasonal1, 2, "prior_seasonal1", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_seasonal1, 4, "prior_seasonal1", 1), 6))) {
                    current_statement_begin__ = 196;
                    lp_accum__.add(inv_gamma_log(seasonal1, get_base1(prior_seasonal1, 1, "prior_seasonal1", 1), get_base1(prior_seasonal1, 2, "prior_seasonal1", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_seasonal1, 4, "prior_seasonal1", 1), 7))) {
                    current_statement_begin__ = 197;
                    lp_accum__.add(inv_chi_square_log(seasonal1, get_base1(prior_seasonal1, 3, "prior_seasonal1", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_seasonal1, 4, "prior_seasonal1", 1), 8))) {
                    current_statement_begin__ = 198;
                    lp_accum__.add(-(stan::math::log(sigma0)));
                } else if (as_bool(logical_eq(get_base1(prior_seasonal1, 4, "prior_seasonal1", 1), 9))) {
                    current_statement_begin__ = 199;
                    lp_accum__.add(gamma_log(seasonal1, get_base1(prior_seasonal1, 1, "prior_seasonal1", 1), get_base1(prior_seasonal1, 2, "prior_seasonal1", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_seasonal1, 4, "prior_seasonal1", 1), 10))) {
                    current_statement_begin__ = 200;
                    lp_accum__.add(exponential_log(seasonal1, get_base1(prior_seasonal1, 2, "prior_seasonal1", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_seasonal1, 4, "prior_seasonal1", 1), 11))) {
                    current_statement_begin__ = 201;
                    lp_accum__.add(chi_square_log(seasonal1, get_base1(prior_seasonal1, 3, "prior_seasonal1", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_seasonal1, 4, "prior_seasonal1", 1), 12))) {
                    current_statement_begin__ = 202;
                    lp_accum__.add(double_exponential_log(seasonal1, get_base1(prior_seasonal1, 1, "prior_seasonal1", 1), get_base1(prior_seasonal1, 2, "prior_seasonal1", 1)));
                }
            }
            current_statement_begin__ = 206;
            if (as_bool(logical_eq(genT, 1))) {
                current_statement_begin__ = 208;
                if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 1))) {
                    current_statement_begin__ = 208;
                    lp_accum__.add(normal_log(get_base1(v, 1, "v", 1), get_base1(prior_dfv, 1, "prior_dfv", 1), get_base1(prior_dfv, 2, "prior_dfv", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 2))) {
                    current_statement_begin__ = 209;
                    lp_accum__.add(beta_log(get_base1(v, 1, "v", 1), get_base1(prior_dfv, 1, "prior_dfv", 1), get_base1(prior_dfv, 2, "prior_dfv", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 3))) {
                    current_statement_begin__ = 210;
                    lp_accum__.add(uniform_log(get_base1(v, 1, "v", 1), get_base1(prior_dfv, 1, "prior_dfv", 1), get_base1(prior_dfv, 2, "prior_dfv", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 4))) {
                    current_statement_begin__ = 211;
                    lp_accum__.add(student_t_log(get_base1(v, 1, "v", 1), get_base1(prior_dfv, 3, "prior_dfv", 1), get_base1(prior_dfv, 1, "prior_dfv", 1), get_base1(prior_dfv, 2, "prior_dfv", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 5))) {
                    current_statement_begin__ = 212;
                    lp_accum__.add(cauchy_log(get_base1(v, 1, "v", 1), get_base1(prior_dfv, 1, "prior_dfv", 1), get_base1(prior_dfv, 2, "prior_dfv", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 6))) {
                    current_statement_begin__ = 213;
                    lp_accum__.add(inv_gamma_log(get_base1(v, 1, "v", 1), get_base1(prior_dfv, 1, "prior_dfv", 1), get_base1(prior_dfv, 2, "prior_dfv", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 7))) {
                    current_statement_begin__ = 214;
                    lp_accum__.add(inv_chi_square_log(get_base1(v, 1, "v", 1), get_base1(prior_dfv, 3, "prior_dfv", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 8))) {
                    current_statement_begin__ = 215;
                    lp_accum__.add(stan::math::log(Jpv(get_base1(v, 1, "v", 1), pstream__)));
                } else if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 9))) {
                    current_statement_begin__ = 216;
                    lp_accum__.add(gamma_log(get_base1(v, 1, "v", 1), get_base1(prior_dfv, 1, "prior_dfv", 1), get_base1(prior_dfv, 2, "prior_dfv", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 10))) {
                    current_statement_begin__ = 217;
                    lp_accum__.add(exponential_log(get_base1(v, 1, "v", 1), get_base1(prior_dfv, 2, "prior_dfv", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 11))) {
                    current_statement_begin__ = 218;
                    lp_accum__.add(chi_square_log(get_base1(v, 1, "v", 1), get_base1(prior_dfv, 3, "prior_dfv", 1)));
                } else if (as_bool(logical_eq(get_base1(prior_dfv, 4, "prior_dfv", 1), 12))) {
                    current_statement_begin__ = 219;
                    lp_accum__.add(double_exponential_log(get_base1(v, 1, "v", 1), get_base1(prior_dfv, 1, "prior_dfv", 1), get_base1(prior_dfv, 2, "prior_dfv", 1)));
                }
                current_statement_begin__ = 222;
                lp_accum__.add(gamma_log(get_base1(v, 1, "v", 1), 2, 0.1));
                current_statement_begin__ = 223;
                lp_accum__.add(inv_gamma_log(get_base1(lambda, 1, "lambda", 1), (get_base1(v, 1, "v", 1) / 2), (get_base1(v, 1, "v", 1) / 2)));
                current_statement_begin__ = 224;
                lp_accum__.add(normal_log(epsilon, 0, (get_base1(v1, 1, "v1", 1) * sigma0)));
            } else {
                current_statement_begin__ = 227;
                lp_accum__.add(normal_log(epsilon, 0, sigma0));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("breg");
        names__.push_back("sigma0");
        names__.push_back("level");
        names__.push_back("trend");
        names__.push_back("damped");
        names__.push_back("seasonal");
        names__.push_back("v");
        names__.push_back("lambda");
        names__.push_back("level1");
        names__.push_back("trend1");
        names__.push_back("seasonal1");
        names__.push_back("mu");
        names__.push_back("epsilon");
        names__.push_back("l");
        names__.push_back("b");
        names__.push_back("s");
        names__.push_back("v1");
        names__.push_back("loglik");
        names__.push_back("log_lik");
        names__.push_back("fit");
        names__.push_back("residuals");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(d1);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(is_td);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(is_dp);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(is_ss);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((genT * 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((genT * 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(is_td);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((m * is_ss));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((is_td * n));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((is_ss * n));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((genT * 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_ets_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> breg = in__.vector_constrain(d1);
        size_t breg_j_1_max__ = d1;
        for (size_t j_1__ = 0; j_1__ < breg_j_1_max__; ++j_1__) {
            vars__.push_back(breg(j_1__));
        }
        double sigma0 = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma0);
        double level = in__.scalar_lub_constrain(0, 1);
        vars__.push_back(level);
        Eigen::Matrix<double, Eigen::Dynamic, 1> trend = in__.vector_lub_constrain(0, 1, is_td);
        size_t trend_j_1_max__ = is_td;
        for (size_t j_1__ = 0; j_1__ < trend_j_1_max__; ++j_1__) {
            vars__.push_back(trend(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> damped = in__.vector_lub_constrain(0, 1, is_dp);
        size_t damped_j_1_max__ = is_dp;
        for (size_t j_1__ = 0; j_1__ < damped_j_1_max__; ++j_1__) {
            vars__.push_back(damped(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> seasonal = in__.vector_lub_constrain(0, 1, is_ss);
        size_t seasonal_j_1_max__ = is_ss;
        for (size_t j_1__ = 0; j_1__ < seasonal_j_1_max__; ++j_1__) {
            vars__.push_back(seasonal(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> v = in__.vector_lb_constrain(2.01, (genT * 1));
        size_t v_j_1_max__ = (genT * 1);
        for (size_t j_1__ = 0; j_1__ < v_j_1_max__; ++j_1__) {
            vars__.push_back(v(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda = in__.vector_lb_constrain(1, (genT * 1));
        size_t lambda_j_1_max__ = (genT * 1);
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            vars__.push_back(lambda(j_1__));
        }
        double level1 = in__.scalar_constrain();
        vars__.push_back(level1);
        Eigen::Matrix<double, Eigen::Dynamic, 1> trend1 = in__.vector_constrain(is_td);
        size_t trend1_j_1_max__ = is_td;
        for (size_t j_1__ = 0; j_1__ < trend1_j_1_max__; ++j_1__) {
            vars__.push_back(trend1(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> seasonal1 = in__.vector_constrain((m * is_ss));
        size_t seasonal1_j_1_max__ = (m * is_ss);
        for (size_t j_1__ = 0; j_1__ < seasonal1_j_1_max__; ++j_1__) {
            vars__.push_back(seasonal1(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 53;
            validate_non_negative_index("mu", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> mu(n);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 54;
            validate_non_negative_index("epsilon", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> epsilon(n);
            stan::math::initialize(epsilon, DUMMY_VAR__);
            stan::math::fill(epsilon, DUMMY_VAR__);
            current_statement_begin__ = 55;
            validate_non_negative_index("l", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> l(n);
            stan::math::initialize(l, DUMMY_VAR__);
            stan::math::fill(l, DUMMY_VAR__);
            current_statement_begin__ = 56;
            validate_non_negative_index("b", "(is_td * n)", (is_td * n));
            Eigen::Matrix<double, Eigen::Dynamic, 1> b((is_td * n));
            stan::math::initialize(b, DUMMY_VAR__);
            stan::math::fill(b, DUMMY_VAR__);
            current_statement_begin__ = 57;
            validate_non_negative_index("s", "(is_ss * n)", (is_ss * n));
            Eigen::Matrix<double, Eigen::Dynamic, 1> s((is_ss * n));
            stan::math::initialize(s, DUMMY_VAR__);
            stan::math::fill(s, DUMMY_VAR__);
            current_statement_begin__ = 58;
            validate_non_negative_index("v1", "(genT * 1)", (genT * 1));
            Eigen::Matrix<double, Eigen::Dynamic, 1> v1((genT * 1));
            stan::math::initialize(v1, DUMMY_VAR__);
            stan::math::fill(v1, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 61;
            if (as_bool(logical_gt(d1, 0))) {
                current_statement_begin__ = 61;
                stan::math::assign(mu, multiply(xreg, breg));
            } else {
                current_statement_begin__ = 62;
                stan::math::assign(mu, rep_vector(0, n));
            }
            current_statement_begin__ = 65;
            stan::model::assign(l, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        level1, 
                        "assigning variable l");
            current_statement_begin__ = 65;
            stan::model::assign(mu, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), "mu") + level1), 
                        "assigning variable mu");
            current_statement_begin__ = 66;
            stan::model::assign(epsilon, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        (get_base1(y, 1, "y", 1) - get_base1(mu, 1, "mu", 1)), 
                        "assigning variable epsilon");
            current_statement_begin__ = 67;
            if (as_bool(logical_eq(is_td, 1))) {
                current_statement_begin__ = 67;
                stan::model::assign(b, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            get_base1(trend1, 1, "trend1", 1), 
                            "assigning variable b");
            }
            current_statement_begin__ = 68;
            if (as_bool(logical_eq(is_ss, 1))) {
                current_statement_begin__ = 68;
                for (int i = 1; i <= m; ++i) {
                    current_statement_begin__ = 68;
                    stan::model::assign(s, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(seasonal1, i, "seasonal1", 1), 
                                "assigning variable s");
                }
            }
            current_statement_begin__ = 71;
            if (as_bool(logical_eq(genT, 1))) {
                current_statement_begin__ = 71;
                stan::model::assign(v1, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            stan::math::sqrt((((get_base1(v, 1, "v", 1) - 2) * get_base1(lambda, 1, "lambda", 1)) / get_base1(v, 1, "v", 1))), 
                            "assigning variable v1");
            }
            current_statement_begin__ = 75;
            for (int i = 2; i <= n; ++i) {
                current_statement_begin__ = 78;
                stan::model::assign(l, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((level * (get_base1(y, i, "y", 1) - get_base1(mu, i, "mu", 1))) + ((1 - level) * get_base1(l, (i - 1), "l", 1))), 
                            "assigning variable l");
                current_statement_begin__ = 79;
                if (as_bool((primitive_value(logical_eq(is_ss, 1)) && primitive_value(logical_gt(i, m))))) {
                    current_statement_begin__ = 79;
                    stan::model::assign(l, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(l, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "l") + (-(level) * get_base1(s, (i - m), "s", 1))), 
                                "assigning variable l");
                }
                current_statement_begin__ = 81;
                stan::model::assign(mu, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "mu") + get_base1(l, (i - 1), "l", 1)), 
                            "assigning variable mu");
                current_statement_begin__ = 84;
                if (as_bool(logical_eq(is_td, 1))) {
                    current_statement_begin__ = 86;
                    if (as_bool(logical_eq(is_dp, 1))) {
                        current_statement_begin__ = 86;
                        stan::model::assign(b, 
                                    stan::model::cons_list(stan::model::index_uni((i - 1)), stan::model::nil_index_list()), 
                                    (get_base1(damped, 1, "damped", 1) * get_base1(b, (i - 1), "b", 1)), 
                                    "assigning variable b");
                    }
                    current_statement_begin__ = 87;
                    stan::model::assign(b, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((get_base1(trend, 1, "trend", 1) * (get_base1(l, i, "l", 1) - get_base1(l, (i - 1), "l", 1))) + ((1 - get_base1(trend, 1, "trend", 1)) * get_base1(b, (i - 1), "b", 1))), 
                                "assigning variable b");
                    current_statement_begin__ = 88;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "mu") + get_base1(b, (i - 1), "b", 1)), 
                                "assigning variable mu");
                }
                current_statement_begin__ = 92;
                if (as_bool(logical_eq(is_ss, 1))) {
                    current_statement_begin__ = 93;
                    if (as_bool(logical_gt(i, m))) {
                        current_statement_begin__ = 94;
                        stan::model::assign(s, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((get_base1(seasonal, 1, "seasonal", 1) * (get_base1(y, i, "y", 1) - get_base1(l, i, "l", 1))) + ((1 - get_base1(seasonal, 1, "seasonal", 1)) * get_base1(s, (i - m), "s", 1))), 
                                    "assigning variable s");
                        current_statement_begin__ = 95;
                        if (as_bool(logical_eq(is_td, 1))) {
                            current_statement_begin__ = 95;
                            stan::model::assign(s, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (stan::model::rvalue(s, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "s") + (-(get_base1(seasonal, 1, "seasonal", 1)) * get_base1(b, i, "b", 1))), 
                                        "assigning variable s");
                        }
                        current_statement_begin__ = 96;
                        stan::model::assign(mu, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "mu") + get_base1(s, (i - m), "s", 1)), 
                                    "assigning variable mu");
                    }
                }
                current_statement_begin__ = 100;
                stan::model::assign(epsilon, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(y, i, "y", 1) - get_base1(mu, i, "mu", 1)), 
                            "assigning variable epsilon");
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 58;
            check_greater_or_equal(function__, "v1", v1, 1);
            // write transformed parameters
            if (include_tparams__) {
                size_t mu_j_1_max__ = n;
                for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                    vars__.push_back(mu(j_1__));
                }
                size_t epsilon_j_1_max__ = n;
                for (size_t j_1__ = 0; j_1__ < epsilon_j_1_max__; ++j_1__) {
                    vars__.push_back(epsilon(j_1__));
                }
                size_t l_j_1_max__ = n;
                for (size_t j_1__ = 0; j_1__ < l_j_1_max__; ++j_1__) {
                    vars__.push_back(l(j_1__));
                }
                size_t b_j_1_max__ = (is_td * n);
                for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                    vars__.push_back(b(j_1__));
                }
                size_t s_j_1_max__ = (is_ss * n);
                for (size_t j_1__ = 0; j_1__ < s_j_1_max__; ++j_1__) {
                    vars__.push_back(s(j_1__));
                }
                size_t v1_j_1_max__ = (genT * 1);
                for (size_t j_1__ = 0; j_1__ < v1_j_1_max__; ++j_1__) {
                    vars__.push_back(v1(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 230;
            double loglik;
            (void) loglik;  // dummy to suppress unused var warning
            stan::math::initialize(loglik, DUMMY_VAR__);
            stan::math::fill(loglik, DUMMY_VAR__);
            stan::math::assign(loglik,0);
            current_statement_begin__ = 231;
            validate_non_negative_index("log_lik", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(n);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            current_statement_begin__ = 232;
            validate_non_negative_index("fit", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> fit(n);
            stan::math::initialize(fit, DUMMY_VAR__);
            stan::math::fill(fit, DUMMY_VAR__);
            current_statement_begin__ = 233;
            validate_non_negative_index("residuals", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> residuals(n);
            stan::math::initialize(residuals, DUMMY_VAR__);
            stan::math::fill(residuals, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 235;
            for (int i = 1; i <= n; ++i) {
                current_statement_begin__ = 236;
                if (as_bool(logical_eq(genT, 1))) {
                    current_statement_begin__ = 237;
                    stan::model::assign(residuals, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                student_t_rng(get_base1(v, 1, "v", 1), get_base1(epsilon, i, "epsilon", 1), sigma0, base_rng__), 
                                "assigning variable residuals");
                    current_statement_begin__ = 238;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                student_t_log(get_base1(y, i, "y", 1), get_base1(v, 1, "v", 1), get_base1(mu, i, "mu", 1), sigma0), 
                                "assigning variable log_lik");
                    current_statement_begin__ = 239;
                    stan::math::assign(loglik, (loglik + get_base1(log_lik, i, "log_lik", 1)));
                } else {
                    current_statement_begin__ = 242;
                    stan::model::assign(residuals, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                normal_rng(get_base1(epsilon, i, "epsilon", 1), sigma0, base_rng__), 
                                "assigning variable residuals");
                    current_statement_begin__ = 243;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                normal_log(get_base1(y, i, "y", 1), get_base1(mu, i, "mu", 1), sigma0), 
                                "assigning variable log_lik");
                    current_statement_begin__ = 244;
                    stan::math::assign(loglik, (loglik + get_base1(log_lik, i, "log_lik", 1)));
                }
            }
            current_statement_begin__ = 247;
            stan::math::assign(fit, subtract(y, residuals));
            // validate, write generated quantities
            current_statement_begin__ = 230;
            vars__.push_back(loglik);
            current_statement_begin__ = 231;
            size_t log_lik_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
            current_statement_begin__ = 232;
            size_t fit_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < fit_j_1_max__; ++j_1__) {
                vars__.push_back(fit(j_1__));
            }
            current_statement_begin__ = 233;
            size_t residuals_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < residuals_j_1_max__; ++j_1__) {
                vars__.push_back(residuals(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_ets";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t breg_j_1_max__ = d1;
        for (size_t j_1__ = 0; j_1__ < breg_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "breg" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "level";
        param_names__.push_back(param_name_stream__.str());
        size_t trend_j_1_max__ = is_td;
        for (size_t j_1__ = 0; j_1__ < trend_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "trend" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t damped_j_1_max__ = is_dp;
        for (size_t j_1__ = 0; j_1__ < damped_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "damped" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t seasonal_j_1_max__ = is_ss;
        for (size_t j_1__ = 0; j_1__ < seasonal_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "seasonal" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t v_j_1_max__ = (genT * 1);
        for (size_t j_1__ = 0; j_1__ < v_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_j_1_max__ = (genT * 1);
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "level1";
        param_names__.push_back(param_name_stream__.str());
        size_t trend1_j_1_max__ = is_td;
        for (size_t j_1__ = 0; j_1__ < trend1_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "trend1" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t seasonal1_j_1_max__ = (m * is_ss);
        for (size_t j_1__ = 0; j_1__ < seasonal1_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "seasonal1" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t mu_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t epsilon_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < epsilon_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "epsilon" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t l_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < l_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "l" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b_j_1_max__ = (is_td * n);
            for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t s_j_1_max__ = (is_ss * n);
            for (size_t j_1__ = 0; j_1__ < s_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "s" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t v1_j_1_max__ = (genT * 1);
            for (size_t j_1__ = 0; j_1__ < v1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "v1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "loglik";
        param_names__.push_back(param_name_stream__.str());
        size_t log_lik_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t fit_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < fit_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "fit" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t residuals_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < residuals_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "residuals" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t breg_j_1_max__ = d1;
        for (size_t j_1__ = 0; j_1__ < breg_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "breg" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "level";
        param_names__.push_back(param_name_stream__.str());
        size_t trend_j_1_max__ = is_td;
        for (size_t j_1__ = 0; j_1__ < trend_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "trend" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t damped_j_1_max__ = is_dp;
        for (size_t j_1__ = 0; j_1__ < damped_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "damped" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t seasonal_j_1_max__ = is_ss;
        for (size_t j_1__ = 0; j_1__ < seasonal_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "seasonal" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t v_j_1_max__ = (genT * 1);
        for (size_t j_1__ = 0; j_1__ < v_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_j_1_max__ = (genT * 1);
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "level1";
        param_names__.push_back(param_name_stream__.str());
        size_t trend1_j_1_max__ = is_td;
        for (size_t j_1__ = 0; j_1__ < trend1_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "trend1" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t seasonal1_j_1_max__ = (m * is_ss);
        for (size_t j_1__ = 0; j_1__ < seasonal1_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "seasonal1" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t mu_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t epsilon_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < epsilon_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "epsilon" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t l_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < l_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "l" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b_j_1_max__ = (is_td * n);
            for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t s_j_1_max__ = (is_ss * n);
            for (size_t j_1__ = 0; j_1__ < s_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "s" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t v1_j_1_max__ = (genT * 1);
            for (size_t j_1__ = 0; j_1__ < v1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "v1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "loglik";
        param_names__.push_back(param_name_stream__.str());
        size_t log_lik_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t fit_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < fit_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "fit" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t residuals_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < residuals_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "residuals" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_ets_namespace::model_ets stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
