% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{report}
\alias{report}
\alias{report.varstan}
\alias{report.Sarima}
\alias{report.garch}
\alias{report.varma}
\alias{report.Bekk}
\alias{report.naive}
\title{Print a full report of the time series model in a  varstan object.}
\usage{
report(object,...)
}
\arguments{
\item{object}{an object varstan object or one of the defined current defined reports in varstan package}

\item{...}{additional values need in print methods}
}
\value{
none. prints a string with the defined time series model report
}
\description{
The function returns a report with the users defined model for the given time series data
and all the current defined priors of the model.
}
\details{
if \code{object} is a varstan object the function will print the information of the
defined model inside of the object. If \code{object} is one of the model classes (like Sarima or garch)
then it will print the report information as well.
}
\examples{
library(astsa)
dat2 = garch(birth,order = c(1,1,0))
report(dat2)

}
\author{
Asael Alonzo Matamoros
}
