% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesMRMApp.R
\name{bayesMRMApp}
\alias{bayesMRMApp}
\title{Shiny App for exploring the results of Bayesian multivariate receptor modeling}
\usage{
bayesMRMApp(x)
}
\arguments{
\item{x}{an object of class \code{bmrm}, the output of the \code{bmrm} function}
}
\value{
shiny App
}
\description{
Call Shiny to show the results of Bayesian analysis of
multivariate receptor modeling in a web-based application.
This object contains
 \itemize{
 \item plots of the posterior means and 95\% posterior intervals of parameters in
an object of class \code{bmrm}.
\item tables of the posterior means of parameters in
an object of class \code{bmrm}.
 \item tables of the posterior quantiles of parameters in
an object of class \code{bmrm}, for prob=(0.025, 0.05, 0.25, 0.5, 0.75, 0.95, 0.975).
\item  tables of convergence diagnostics of parameters in
an object of class \code{bmrm}.
 \item 3-dimensional dynamic principal component plots of data (Y) and
source profiles (rows of the estimated source composition matrix P)
in an object of class \code{bmrm}. The plot can be rotated by moving the cursor.
 \item trace plots and ACF plots of the first 6 elements of a parameter in an
 object of class \code{bmrm}.
 }
}
