% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b_bootstrap.R
\name{b_bootstrap}
\alias{b_bootstrap}
\title{b_bootstrap}
\usage{
b_bootstrap(data, statistic, n1 = 1000, n2 = 1000,
  use_weights = FALSE, weight_arg = NULL, ...)
}
\arguments{
\item{data}{The data as either a vector, matrix or data.frame.}

\item{statistic}{A function that accepts data as its first argument and if use_weights is TRUE the weights as its second argument. Function should return a numeric vector.}

\item{n1}{The size of the bootstrap sample (default = 1000).}

\item{n2}{The sample size used to calculate the statistic each bootstrap draw (default = 1000).}

\item{use_weights}{Whether the statistic function accepts a weight argument or should be calculated using resampled data (default = FALSE).}

\item{weight_arg}{If the statistic function includes a named argument for the weights this could be specified here (default = NULL).}

\item{...}{Further arguments passed on to the statistic function.}
}
\value{
A data frame containing bootstrap samples.
}
\description{
Performs a Bayesian bootstrap and returns a sample of size n1 representing the posterior distribution of the statistic. Returns a vector if the statistic is one-dimensional (like for mean(...)) or a data.frame if the statistic is multi-dimensional (like for the coefficients of lm).
}
\examples{

# linear function of seqence vs. response
lm_statistic <- function(data) {
  lm(sequence ~ response, data)$coef
}

# load data
data <- adaptation_level_small

# bootstrap
data_bootstrap <- b_bootstrap(data, lm_statistic, n1=1000, n2=1000)

}
\references{
\url{http://www.sumsar.net/blog/2015/07/easy-bayesian-bootstrap-in-r/}

Rubin, D. B. (1981). The Bayesian Bootstrap. The annals of statistics, 9(1), 130-134.
}
\author{
Rasmus Baath
}
