context("ExperimentRegistry")

test_that("makeTestExperimentRegistry", {
  reg = makeTestExperimentRegistry()
  expect_is(reg, "Registry")
  expect_is(reg, "ExperimentRegistry")
  expect_true(is.environment(reg))
  expect_directory(reg$file.dir, access = "rw")
  expect_directory(reg$work.dir, access = "r")
  expect_directory(fs::path(reg$file.dir, c("jobs", "results", "updates", "logs")))
  expect_file(fs::path(reg$file.dir, "registry.rds"))
  expect_character(reg$packages, any.missing = FALSE)
  expect_character(reg$namespaces, any.missing = FALSE)
  expect_int(reg$seed, na.ok = FALSE)
  expect_true(reg$writeable)
  expect_is(reg$cluster.functions, "ClusterFunctions")
  expect_list(reg$default.resources, names = "strict")
  checkTables(reg, any.missing = FALSE, nrows = 0L)
  expect_character(reg$problems, len = 0L)
  expect_character(reg$algorithms, len = 0L)
  expect_output(print(reg), "Experiment Registry")
})

test_that("Printer works (#170)", {
  reg = makeTestExperimentRegistry()
  expect_character(reg$problems, len = 0L)
  expect_character(reg$algorithms, len = 0L)
  expect_output(print(reg), "Problems[[:space:]]*:[[:space:]]*0")
  expect_output(print(reg), "Algorithms[[:space:]]*:[[:space:]]*0")
  addProblem("iris", data = iris, reg = reg)
  addAlgorithm("foo", fun = function(...) list(...), reg = reg)
  expect_character(reg$problems, len = 1L, any.missing = FALSE)
  expect_character(reg$algorithms, len = 1L, any.missing = FALSE)
  expect_output(print(reg), "Problems[[:space:]]*:[[:space:]]*1")
  expect_output(print(reg), "Algorithms[[:space:]]*:[[:space:]]*1")
})
