% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterFunctions.R
\name{makeSubmitJobResult}
\alias{makeSubmitJobResult}
\alias{SubmitJobResult}
\title{Create a SubmitJobResult}
\usage{
makeSubmitJobResult(status, batch.id, log.file = NA_character_,
  msg = NA_character_)
}
\arguments{
\item{status}{[\code{integer(1)}]\cr
Launch status of job. 0 means success, codes between 1 and 100 are temporary errors and any
error greater than 100 is a permanent failure.}

\item{batch.id}{[\code{character()}]\cr
Unique id of this job on batch system, as given by the batch system.
Must be globally unique so that the job can be terminated using just this information.
For array jobs, this may be a vector of length equal to the number of jobs in the array.}

\item{log.file}{[\code{character()}]\cr
Log file. If \code{NA}, defaults to \code{[job.hash].log}.
Some cluster functions set this for array jobs.}

\item{msg}{[\code{character(1)}]\cr
Optional error message in case \code{status} is not equal to 0. Default is \dQuote{OK},
\dQuote{TEMPERROR}, \dQuote{ERROR}, depending on \code{status}.}
}
\value{
[\code{\link{SubmitJobResult}}]. A list, containing
  \code{status}, \code{batch.id} and \code{msg}.
}
\description{
This function is only intended for use in your own cluster functions implementation.

Use this function in your implementation of \code{\link{makeClusterFunctions}} to create a return
value for the \code{submitJob} function.
}
\seealso{
Other ClusterFunctionsHelper: \code{\link{cfBrewTemplate}},
  \code{\link{cfHandleUnknownSubmitError}},
  \code{\link{cfKillJob}},
  \code{\link{cfReadBrewTemplate}},
  \code{\link{makeClusterFunctions}},
  \code{\link{runOSCommand}}
}
\concept{ClusterFunctionsHelper}
