% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getStatus.R
\name{getStatus}
\alias{getStatus}
\title{Summarize the Computational Status}
\usage{
getStatus(ids = NULL, reg = getDefaultRegistry())
}
\arguments{
\item{ids}{[\code{\link[base]{data.frame}} or \code{integer}]\cr
A \code{\link[base]{data.frame}} (or \code{\link[data.table]{data.table}})
with a column named \dQuote{job.id}.
Alternatively, you may also pass a vector of integerish job ids.
If not set, defaults to all jobs.}

\item{reg}{[\code{\link{Registry}}]\cr
Registry. If not explicitly passed, uses the default registry (see \code{\link{setDefaultRegistry}}).}
}
\value{
[\code{\link[data.table]{data.table}}] (with class \dQuote{Status} for printing).
}
\description{
This function gives an encompassing overview over the computational status on your system.
}
\examples{
tmp = makeRegistry(file.dir = NA, make.default = FALSE)
fun = function(i) if (i == 3) stop(i) else i
ids = batchMap(fun, i = 1:5, reg = tmp)
submitJobs(ids = 1:4, reg = tmp)
waitForJobs(reg = tmp)

tab = getStatus(reg = tmp)
print(tab)
str(tab)
}
\seealso{
Other debug: \code{\link{getErrorMessages}},
  \code{\link{grepLogs}}, \code{\link{killJobs}},
  \code{\link{resetJobs}}, \code{\link{showLog}},
  \code{\link{testJob}}
}

