% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkProposalWindows.R
\name{checkProposalWindows}
\alias{checkProposalWindows}
\title{Check proposal windows}
\usage{
checkProposalWindows(
  mu_proposal_window,
  cov_proposal_window,
  m_proposal_window,
  S_proposal_window,
  t_df_proposal_window,
  verbose = TRUE
)
}
\arguments{
\item{mu_proposal_window}{The proposal window for the cluster mean proposal
kernel. The proposal density is a Gaussian distribution, the window is the 
variance.}

\item{cov_proposal_window}{The proposal window for the cluster covariance
proposal kernel. The proposal density is a Wishart distribution, this 
argument is the reciprocal of the degree of freedom.}

\item{m_proposal_window}{The proposal window for the batch mean proposal
 kernel. The proposal density is a Gaussian distribution, the window is the 
variance.}

\item{S_proposal_window}{The proposal window for the batch standard deviation
 proposal kernel. The proposal density is a Gamma distribution, this 
argument is the reciprocal of the rate.}

\item{t_df_proposal_window}{The proposal window for the degrees of freedom
for the multivariate t distribution (not used if type is not 'MVT'). The 
proposal density is a Gamma distribution, this argument is the reciprocal of
the rate.}

\item{verbose}{Logical indicating if a warning should be printed if proposal 
windows are outside their expected scale.}
}
\value{
No return value, called for side effects
}
\description{
Checks the proposal windows are acceptable.
}
\examples{
checkProposalWindows(0.1, 0.2, 0.3, 0.1, 0.4, 0.3)
}
