% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FlexTableStyle.R
\docType{class}
\name{FlexTableStyle}
\alias{FlexTableStyle}
\title{R6 class that specifies styling as used by the `flextable` package.}
\format{
\code{\link{R6Class}} object.
}
\description{
The `FlexTableStyle` class specifies the styling for cells in a
table from the flextable package.
}
\examples{
# This class should only be created by using the functions in the table.
# It is not intended to be created by users outside of the table.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{baseStyleName}}{The name of the base style in the table.}

\item{\code{isBaseStyle}}{`TRUE` when this style is the equivalent of a named style in
the table, `FALSE` if this style has additional settings over and above
the base style of the same name.}

\item{\code{fontName}}{The name of the font (single font name, not a CSS style
list).}

\item{\code{fontSize}}{The size of the font (units: point).}

\item{\code{bold}}{TRUE` if text is bold.}

\item{\code{italic}}{`TRUE` if text is italic.}

\item{\code{bgColor}}{The background colour for the cell (as a hex value, e.g.
#00FF00).}

\item{\code{textColor}}{The color of the text (as a hex value).}

\item{\code{hAlign}}{The horizontal alignment of the text:  left, center or right.}

\item{\code{vAlign}}{The vertical alignment of the text:  top, middle or bottom.}

\item{\code{textRotation}}{The rotation angle of the text or 255 for vertical.}

\item{\code{paddingAll}}{The padding to apply to all sides of each cell.}

\item{\code{paddingLeft}}{The padding to apply to the left side of each cell.}

\item{\code{paddingRight}}{The padding to apply to the right side of each cell.}

\item{\code{paddingTop}}{The padding to apply to the top of each cell.}

\item{\code{paddingBottom}}{The padding to apply to the bottom of each cell.}

\item{\code{borderAll}}{A list (with elements style, color and width) specifying the border
settings for all four sides of each cell at once.}

\item{\code{borderLeft}}{A list (with elements style, color and width) specifying the
border settings for the left border of each cell.}

\item{\code{borderRight}}{A list (with elements style, color and width) specifying the
border settings for the right border of each cell.}

\item{\code{borderTop}}{A list (with elements style, color and width) specifying the border
settings for the top border of each cell.}

\item{\code{borderBottom}}{A list (with elements style, color and width) specifying the
border settings for the bottom border of each cell.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{FlexTableStyle$new()}}
\item \href{#method-isBasicStyleNameMatch}{\code{FlexTableStyle$isBasicStyleNameMatch()}}
\item \href{#method-isFullStyleDetailMatch}{\code{FlexTableStyle$isFullStyleDetailMatch()}}
\item \href{#method-asList}{\code{FlexTableStyle$asList()}}
\item \href{#method-asJSON}{\code{FlexTableStyle$asJSON()}}
\item \href{#method-asString}{\code{FlexTableStyle$asString()}}
\item \href{#method-clone}{\code{FlexTableStyle$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new `FlexTableStyle` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FlexTableStyle$new(
  parentTable,
  baseStyleName = NULL,
  isBaseStyle = NULL,
  fontName = NULL,
  fontSize = NULL,
  bold = NULL,
  italic = NULL,
  bgColor = NULL,
  textColor = NULL,
  hAlign = NULL,
  vAlign = NULL,
  textRotation = NULL,
  paddingAll = NULL,
  paddingLeft = NULL,
  paddingRight = NULL,
  paddingTop = NULL,
  paddingBottom = NULL,
  borderAll = NULL,
  borderLeft = NULL,
  borderRight = NULL,
  borderTop = NULL,
  borderBottom = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parentTable}}{Owning table.}

\item{\code{baseStyleName}}{The name of the base style in the table.}

\item{\code{isBaseStyle}}{`TRUE` when this style is the equivalent of a named style in
the table, `FALSE` if this style has additional settings over and above
the base style of the same name.}

\item{\code{fontName}}{The name of the font (single font name, not a CSS style
list).}

\item{\code{fontSize}}{The size of the font (units: point).}

\item{\code{bold}}{`TRUE` if text is bold.}

\item{\code{italic}}{`TRUE` if text is italic.}

\item{\code{bgColor}}{The background colour for the cell (as a hex value, e.g.
#00FF00).}

\item{\code{textColor}}{The color of the text (as a hex value).}

\item{\code{hAlign}}{The horizontal alignment of the text:  left, center or right.}

\item{\code{vAlign}}{The vertical alignment of the text:  top, middle or bottom.}

\item{\code{textRotation}}{The rotation angle of the text or 255 for vertical.}

\item{\code{paddingAll}}{The padding to apply to all sides of each cell.}

\item{\code{paddingLeft}}{The padding to apply to the left side of each cell.}

\item{\code{paddingRight}}{The padding to apply to the right side of each cell.}

\item{\code{paddingTop}}{The padding to apply to the top of each cell.}

\item{\code{paddingBottom}}{The padding to apply to the bottom of each cell.}

\item{\code{borderAll}}{A list (with elements style, color and width) specifying
the border settings for all four sides of each cell at once.}

\item{\code{borderLeft}}{A list (with elements style, color and width)
specifying the border settings for the left border of each cell.}

\item{\code{borderRight}}{A list (with elements style, color and width)
specifying the border settings for the right border of each cell.}

\item{\code{borderTop}}{A list (with elements style, color and width) specifying
the border settings for the top border of each cell.}

\item{\code{borderBottom}}{A list (with elements style, color and width)
specifying the border settings for the bottom border of each cell.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isBasicStyleNameMatch"></a>}}
\if{latex}{\out{\hypertarget{method-isBasicStyleNameMatch}{}}}
\subsection{Method \code{isBasicStyleNameMatch()}}{
Check if this style matches the specified base style name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FlexTableStyle$isBasicStyleNameMatch(baseStyleName = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{baseStyleName}}{The style name to compare to.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
`TRUE` if the style name matches, `FALSE` otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isFullStyleDetailMatch"></a>}}
\if{latex}{\out{\hypertarget{method-isFullStyleDetailMatch}{}}}
\subsection{Method \code{isFullStyleDetailMatch()}}{
Check if this style matches the specified style properties.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FlexTableStyle$isFullStyleDetailMatch(
  baseStyleName = NULL,
  isBaseStyle = NULL,
  fontName = NULL,
  fontSize = NULL,
  bold = NULL,
  italic = NULL,
  bgColor = NULL,
  textColor = NULL,
  hAlign = NULL,
  vAlign = NULL,
  textRotation = NULL,
  paddingAll = NULL,
  paddingLeft = NULL,
  paddingRight = NULL,
  paddingTop = NULL,
  paddingBottom = NULL,
  borderAll = NULL,
  borderLeft = NULL,
  borderRight = NULL,
  borderTop = NULL,
  borderBottom = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{baseStyleName}}{The style name to compare to.}

\item{\code{isBaseStyle}}{Whether the style being compared to is a base style.}

\item{\code{fontName}}{The font name to compare to.}

\item{\code{fontSize}}{The font size to compare to.}

\item{\code{bold}}{The style property bold to compare to.}

\item{\code{italic}}{The style property italic to compare to.}

\item{\code{bgColor}}{The style property bgColor to compare to.}

\item{\code{textColor}}{The style property textColor to compare to.}

\item{\code{hAlign}}{The style property hAlign to compare to.}

\item{\code{vAlign}}{The style property vAlign to compare to.}

\item{\code{textRotation}}{The style property textRotation to compare to.}

\item{\code{paddingAll}}{The padding to apply to all sides of each cell.}

\item{\code{paddingLeft}}{The padding to apply to the left side of each cell.}

\item{\code{paddingRight}}{The padding to apply to the right side of each cell.}

\item{\code{paddingTop}}{The padding to apply to the top of each cell.}

\item{\code{paddingBottom}}{The padding to apply to the bottom of each cell.}

\item{\code{borderAll}}{The style property borderAll to compare to.}

\item{\code{borderLeft}}{The style property borderLeft to compare to.}

\item{\code{borderRight}}{The style property borderRight to compare to.}

\item{\code{borderTop}}{The style property borderTop to compare to.}

\item{\code{borderBottom}}{The style property borderBottom to compare to.}

\item{\code{valueFormat}}{The style value format to compare to.}

\item{\code{minColumnWidth}}{The style property minColumnWidth to compare to.}

\item{\code{minRowHeight}}{The style property minRowHeight to compare to.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
`TRUE` if the style matches, `FALSE` otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-asList"></a>}}
\if{latex}{\out{\hypertarget{method-asList}{}}}
\subsection{Method \code{asList()}}{
Return the contents of this object as a list for debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FlexTableStyle$asList()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-asJSON"></a>}}
\if{latex}{\out{\hypertarget{method-asJSON}{}}}
\subsection{Method \code{asJSON()}}{
Return the contents of this object as JSON for debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FlexTableStyle$asJSON()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A JSON representation of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-asString"></a>}}
\if{latex}{\out{\hypertarget{method-asString}{}}}
\subsection{Method \code{asString()}}{
Return the contents of this object as a string for debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FlexTableStyle$asString()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character representation of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FlexTableStyle$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
