basictabler 0.3.1
================

This is a maintenance release that fixes a couple of compatibility issues around the new default of stringsAsFactors=FALSE in data.frame() in the upcoming R 4.0.0 release.


basictabler 0.3.0
================

Overview
--------

This release includes two small potentially breaking changes to the HTML generated by the package and one bug fix.

Breaking Changes
----------------

**Changes to table header cells in HTML**

When generating HTML, previous versions of the package rendered all cells using the html **td** element.  More correctly, header cells should be rendered using the **th** element.  

This behaviour also causes compatibility issues with the `pivottabler` package, which already renders header cells using **th** - i.e. pivot tables converted to basic tables were rendered differently by `basictabler` compared to `pivottabler`.

Starting from this version of `basictabler`, header cells are rendered as **th** elements.  In most cases, this will make no difference to the visual appearance of the table, however it may cause issues for users who require the previous behaviour.  The previous behaviour is still available by specifying `compatibility=list(headerCellsAsTD=TRUE)` as an argument when creating the table, either in `BasicTable$new()` or one of the quick table functions such as `qtbl()`.

Originally reported by @rickwargo (thanks!).

**Changes to rowspan and colspan attributes in HTML**

When generating HTML, v0.2.0 would always generate rowspan and colspan attributes for merged table cells, even if the number of rows or columns being spanned was only one.  Starting with v0.3.0, rowspan and colspan attributes are only generated where the number of rows or columns being spanned is greater than one.  This should make no difference to the visual appearance of the table, however it may cause issues for users who require the previous behaviour.  The previous behaviour is still available by specifying `compatibility=list(explicitHeaderSpansOfOne=TRUE)` as an argument when creating the table, either in `BasicTable$new()` or one of the quick table functions such as `qtbl()`.

Bug Fixes
----------------

Calling `tbl$setStyling()` on the same cell multiple times now succeeds (previously failed with error).  Originally reported by @palatinuse (thanks!).


basictabler 0.2.0
================

Overview
--------

This release includes:

* Table cell merging
* Many small styling improvements
* More styling information and examples in the vignettes

Breaking Changes
----------------

The default value of the `specifyCellsAsList` argument in the `tbl$getCells()` function has been changed to `TRUE` (previously `FALSE`) since this argument usage is more intuitive and is consistent with the `pt$getCells()` function in the `pivottabler` package. 

Improvements
----------------

* Ability to merge table cells.  See the "Working with Cells" vignette for an example.
* Specifying the styling/formatting of individual cells/groups of cells is now simpler using the `tbl$setStyling()` function.  See the "Styling" vignette and the "Finding and Formatting" vignette for more details and examples. 
* Specifying styling/formatting when creating tables using the `qtbl()` and `qhtbl()` functions is now possible.  See the "Introduction" vignette for a list of parameters for these functions.  See the "Styling" vignette for more examples. 
* Specifying styling/formatting when creating tables from a data frame or row-by-row, column-by-column and cell-by-cell is now possible.  Again, see the "Styling" vignette and the "Finding and Formatting" vignette for more details and examples.
* A more detailed explanation of styling rules has been added to the "Styling" vignette.


basictabler 0.1.1
================

Bug Fixes
----------------

Tiny change to correct the index entry of the second vignette.


basictabler 0.1.0
================

Initial version.


Earlier versions
================

No versions prior to 0.1.0 were released.
