% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download}
\alias{download}
\title{Write the results of a query locally to a comma-separated file.}
\usage{
download(
  query = NULL,
  table = NULL,
  path,
  billing_project_id = get_billing_id(),
  .na = " "
)
}
\arguments{
\item{query}{a string containing a valid SQL query.}

\item{table}{defaults to \code{NULL}. If a table name is provided then it'll be concatenated with "basedosdados." and the whole table will be returned.}

\item{path}{String with the output file's name. If running an R Project relative location can be provided. Passed to \code{readr::write_csv}'s \code{file} argument.}

\item{billing_project_id}{a string containing your billing project id. If you've run \code{set_billing_id} then feel free to leave this empty.}

\item{.na}{how should missing values be written in the resulting file? Value passed to \code{na} argument of \code{readr::write_csv}. Defaults to a whitespace.}
}
\value{
Invisibly returns the query's output in a tibble. Intended to be used for side-effects. If you simply want to load a query's result in memory, use \code{read_sql}.
}
\description{
Write the results of a query locally to a comma-separated file.
}
\details{
Currently there's only support for UTF-8 encoding. Users requiring more control over writing should use \code{read_sql} to get the data in memory and custom code from there.
}
\examples{

\dontrun{

path <- file.path(tempdir(), "pib_per_capita.csv")

bare_query <- "SELECT *
FROM basedosdados.br_tse_eleicoes.bens_candidato
WHERE ano = 2020
AND sigla_uf = \'TO\'"

download(query = bare_query, path = path)

# or download the entire table
download(table = "br_tse_eleicoes.bens_candidato", path = path)

}


}
