% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tidy_names_types_factors.R
\name{assign_factorial_levels}
\alias{assign_factorial_levels}
\title{Assign custom values for key levels in factorial columns}
\usage{
assign_factorial_levels(data, factor_keys_values)
}
\arguments{
\item{data}{data.frame to modify}

\item{factor_keys_values}{named list with:
\itemize{
\item Keys: Names of factor columns
\item values: Named vectors with
\itemize{
\item keys: current value (string representation)
\item values: new value to be assigned
\item if a 'default' key is passed, all values not conforming to the new scheme will be converted to the 'default' value
}
}}
}
\value{
data frame with new levels
}
\description{
Use a named vector of keys (current value) and values for factorial columns
to assign meaningful levels and/or group levels
}
\examples{
data <- data.frame(col1 = as.factor(rep(c('1', '2', '4'), 5)))
keys_1 <- list('col1' = c('1' = 'One', '2' = 'Two', '4' = 'Four'))
data_1 <- assign_factorial_levels(data, keys_1)
keys_2 <- list('col1' = c('1' = 'One', 'default' = 'Not_One'))
data_2 <- assign_factorial_levels(data, keys_2)

}
\author{
J. Peter Marqurdt
}
