% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bso-phenology-results.R
\name{bso_get_flight_rst}
\alias{bso_get_flight_rst}
\alias{bso_get_flight_df}
\alias{bso_get_flight}
\title{Get flight of individuals (BSO only)}
\usage{
bso_get_flight_rst(pheno, generation, flight = 1, dates = prop_dates(pheno))

bso_get_flight_df(
  pheno,
  generation,
  stations = prop_stations(pheno),
  flight = 1,
  dates = prop_dates(pheno)
)
}
\arguments{
\item{pheno}{A BSO phenology (see \code{\link[=bso_phenology]{bso_phenology()}})}

\item{generation}{Generation of interest. For sister broods, 0.5 should be added.}

\item{flight}{Specifies which flight of the respective generation should be
returned. Can be \code{1} (first flight) or \code{2} (second flight).}

\item{dates}{Select dates that should be present in the output.}

\item{stations}{Pass a character vector to choose stations assigned to \code{pheno} by
their names, or pass different stations. See \code{\link[=stations_create]{stations_create()}} for details.}
}
\value{
\itemize{
\item \code{bso_get_flight_rst}: a multi-layer SpatRaster.
\item \code{bso_get_flight_df}: a data frame.
}
}
\description{
Get the number of individuals that are flying.
}
\examples{
\donttest{
# This may take a few minutes...

# calculate phenology
p <- bso_phenology('bso', barrks_data('stations'), .quiet = TRUE)

# get the number of individuals of the hibernating generation on their first flight
bso_get_flight_df(p, 0, 'Freiburg', flight = 1)
}
}
