% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaccard.R
\name{jaccard}
\alias{jaccard}
\title{jaccard: Estimates the Jaccard index for comparing two binary maps}
\usage{
jaccard(m1, m2)
}
\arguments{
\item{m1}{A binary raster A or an object of class setA returned by
the function \code{\link[bamm]{model2sparse}}.}

\item{m2}{A binary raster A or an object of class setA returned by
the function \code{\link[bamm]{model2sparse}}.}
}
\value{
Returns a data.frame with three values: 1) jaccard (Jaccard index),
2) percentage_m1 (the percentage of m1 that the
intersection \eqn{|A \cap B|} represents), and 3) percentage_m2
}
\description{
Estimates the Jaccard index for comparing two binary maps
}
\details{
The Jaccard index is computed as follows
\deqn{J(A,B)={{|A\cap B|}\over{|A\cup B|}}={{|A\cap B|}\over{|A|+|B|-|A\cap B|}}.
}
}
\examples{
m1_path <- system.file("extdata/conejos/Lepus_othus_cont.tif",
                       package = "bamm")
m2_path <- system.file("extdata/conejos/Brachylagus_idahoensis_cont.tif",
                       package = "bamm")
m1 <- raster::raster(m1_path) > 0.01
m2 <- raster::raster(m2_path) >0.01
jcc <- bamm::jaccard(m1,m2)
print(jcc)
}
\author{
Luis Osorio-Olvera & Jorge Soberón
}
