% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_estimates.R
\name{get_estimates}
\alias{get_estimates}
\title{Get estimates from a model object}
\usage{
get_estimates(x, ...)
}
\arguments{
\item{x}{A model object.}

\item{...}{Parameters passed to and from other functions.}
}
\value{
An object of class 'model_estimates'
}
\description{
Get estimates from a model object.
This convenience function allows you to see that coefficients are properly
extracted, note how their names will be parsed, and inspect their values.
}
\examples{
\dontrun{
# Example 1
m_tt <- t.test(iris$Sepal.Length[1:20], iris$Sepal.Length[21:40])
get_estimates(m_tt)
# Example 2
m_lm <- lm(Sepal.Length ~., iris)
get_estimates(m_lm)
}
}
\keyword{internal}
