% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{frommatrix}
\alias{frommatrix}
\title{Converts a backbone adjacency matrix to a graph object of specified class}
\usage{
frommatrix(mat, attribs = NA, convert = "matrix")
}
\arguments{
\item{mat}{an adjacency matrix}

\item{attribs}{dataframe: vertex attributes to be assigned in igraph object}

\item{convert}{class to convert to, one of "matrix", "Matrix", "igraph", or "edgelist"}
}
\value{
backbone graph: Binary or signed backbone graph of class \code{convert}.
}
\description{
Converts a backbone adjacency matrix to a graph object of specified class
}
\examples{
M <- matrix(sample(c(-1,0,1),5*5,replace=TRUE),5,5)
test <- backbone:::frommatrix(M, "Matrix")
}
\keyword{internal}
