% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDailyMaxResults.R
\name{plotDailyMaxResults}
\alias{plotDailyMaxResults}
\title{plotDailyMaxResults}
\usage{
plotDailyMaxResults(
  results,
  labels = c("babsim", "DIVI"),
  title = "Betten: Tuerkis = Readfssldaten, Rot = Simulation",
  showBeds = FALSE,
  icuDataRegion = NULL
)
}
\arguments{
\item{results}{Results from \code{getDailyMax}.}

\item{labels}{Axes labels (vector). Default: \code{c('babsim', 'DIVI')}}

\item{title}{Title. Default:
\code{'Betten: Tuerkis = Realdaten, Rot = Simulation'}}

\item{showBeds}{should normal beds be shown in the plot?}

\item{icuDataRegion}{regional \code{icudata}}
}
\value{
This function returns a \code{ggplot} object.
}
\description{
Plot output from \code{getDailyMax()}.
}
\examples{
set.seed(123)
# 1. Generate simulation data based on number of infected persons per day:
x <- dataCovidBeds20200624
StartDate <- x$Day[1]
EndDate <- x$Day[length(x$Day)]
arrivalTimes <- getArrivalTimes(x$Infected)
para <- babsimHospitalPara()
conf <- babsimToolsConf()
y <- babsimHospital(
  arrivalTimes = arrivalTimes,
  conf = conf,
  para = para
)

# 2. Extract real data:
fieldEvents <- getRealBeds(
  data = babsim.hospital::dataCovidBeds20200624,
  resource = c("bed", "intensiveBed", "intensiveBedVentilation")
)
conf <- babsimToolsConf()
# 3. Combine simlated and real data:
res <- getDailyMaxResults(
  envs = y,
  fieldEvents = fieldEvents,
  conf = conf
)
# 4. Plot results
p <- plotDailyMaxResults(res)
# print(p)
}
