% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postprocessEnvs.R
\name{postprocessEnvs}
\alias{postprocessEnvs}
\title{postprocessEnvs}
\usage{
postprocessEnvs(envs, StartDate = "2020-03-03")
}
\arguments{
\item{envs}{\code{\link[simmer]{simmer}} simulation environment.
Result from \code{babsim.hospital} simulation runs, e.g., output from \code{\link{babsimHospital}}.}

\item{StartDate}{Date[1:1], format: 'YYYY-MM-DD' First day of the simulation. Default: \code{'2020-03-03'}.}
}
\value{
This function returns an env data frame (tibble [nxm, 15] (S3: grouped_df/tbl_df/tbl/data.frame))
with the following entries:
\describe{
    \item{\code{resource} (chr)}{name of the seized resource: 'bed' 'bed' 'bed' 'bed' ...}
    \item{\code{time} (num)}{time step:  3 10 12 13 14 15 15 15 15 16 ...}
    \item{\code{server} (int)}{server: 1 2 3 2 3 4 3 4 5 6 ...}
    \item{\code{limit} (num)}{limit: Inf Inf Inf Inf Inf ...}
    \item{\code{replication} (int)}{replication:  1 1 1 1 1 1 1 1 1 1 ...}
    \item{\code{upper} (int)}{upper: 1 2 3 2 3 5 5 5 5 7 ...}
    \item{\code{lower} (int)}{lower: 1 2 3 2 3 3 3 3 3 5 ...}
    \item{\code{med} (num)}{med: 1 2 3 2 3 4 4 4 4 6 ...}
    \item{\code{date} (POSIXct)}{time, format: \code{yyyy-mm-dd hh:mm.ss}}
    \item{\code{rwdate} (POSIXct)}{format: '2020-03-01' '2020-03-08' '2020-03-15' '2020-03-15' ...}
    \item{\code{source} (chr)}{name of the simulation that was used: 'babsim' 'babsim' 'babsim' 'babsim' ...}
    }
}
\description{
Postprocess results from several \code{\link[simmer]{simmer}} results.
Input: \code{\link[simmer]{simmer}} simulation environment.
The method \code{\link[simmer]{get_mon_resources}} function is used to extract information from
the \code{babsim.hospital} simulation.
}
\details{
\code{\link[simmer]{get_mon_resources}} returns state changes in resources:
\itemize{
 \item{'resource': }{resources name}
 \item{'time': }{time instant of the event that triggered the state change}
 \item{'server': }{server count}
 \item{'queue': }{queue count}
 \item{'capacity': }{capacity}
 \item{'queue_size': }{queue size}
 \item{'system': }{system count (server + queue). If no queues are used, system values equal server values.}
 \item{'system_limit': }{system limit (capacity + queue_size)}
 }
}
\section{\code{\link{plotPostprocessedEnvs}}}{
NA
}

\examples{
set.seed(123)
# 1. Generate simulation data based on number of infected persons per day:
x <- dataCovidBeds20200624
StartDate <- x$Day[1]
EndDate <- x$Day[length(x$Day)]
arrivalTimes <- getArrivalTimes(x$Infected)
para <- babsimHospitalPara()
conf <- babsimToolsConf()
y <- babsimHospital(
  arrivalTimes = arrivalTimes,
  conf = conf,
  para = para
)

# 2. Postprocess simulation results:
res <- postprocessEnvs(envs = y)
# 3. Plot results
p <- plotPostprocessedEnvs(res)
}
