% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getArrivalTimes.R
\name{getArrivalTimes}
\alias{getArrivalTimes}
\title{getArrivalTimes}
\usage{
getArrivalTimes(xDaily)
}
\arguments{
\item{xDaily}{Vector that contains the number of arrivals for each day.}
}
\value{
This function returns a data frame of arrival times with the following entries:
\describe{
    \item{\code{time} (num)}{name of the seized resource}
  }

  @seealso \code{\link{rkiToBabsimArrivals}}
}
\description{
Generate arrival times.
}
\examples{
x <- dataCovidBeds20200624
arrivalTimes <- getArrivalTimes(xDaily = x$Infected)
# For RKI data, use rkiToBabsimArrivals as follows:
arrivalTimes <- rkiToBabsimArrivals(rki = babsim.hospital::rkidata)
}
