% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babsimrun.R
\name{runoptDirect}
\alias{runoptDirect}
\title{runoptDirect Optimierung der babsim.hospital Parameter}
\usage{
runoptDirect(
  expName = "obkpara20201017",
  rkiwerte = babsim.hospital::rkidata,
  icuwerte = babsim.hospital::icudata,
  region = 5374,
  TrainFieldStartDate = NULL,
  TrainSimStartDate = NULL,
  TestFieldStartDate = NULL,
  TestSimStartDate = NULL,
  Overlap = 7,
  verbosity = 0,
  seed = 123,
  direct = FALSE,
  repeats = 1,
  funEvals = 35,
  funEvalsFactor = 0,
  size = 30,
  simrepeats = 2,
  subset = 32,
  parallel = FALSE,
  percCores = NULL,
  icu = TRUE,
  icuWeights = 1,
  testRepeats = 3,
  resourceNames = c("intensiveBed", "intensiveBedVentilation"),
  resourceEval = c("intensiveBed", "intensiveBedVentilation"),
  spotEvalsParallel = FALSE,
  tryOnTestSet = TRUE
)
}
\arguments{
\item{expName}{Experiment Name}

\item{rkiwerte}{RKI Daten}

\item{icuwerte}{ICU Daten}

\item{region}{Landkreis Id, e.g., \code{5374} fuer OBK, \code{5315} fuer Koeln,
\code{0} fuer Deutschland,
oder Bundesland ID, e.g., \code{5} fuer NRW.}

\item{TrainFieldStartDate}{Start (Tag), e.g., \code{"2020-06-01"}}

\item{TrainSimStartDate}{Start (Tag), e.g., \code{"2020-05-01"}}

\item{TestFieldStartDate}{Start (Day), e.g., \code{"2020-06-01"} for test field data}

\item{TestSimStartDate}{Start (Day), e.g., \code{"2020-05-01"} for test simulation data,
TestSimStartDate is usually before TestFieldStartDate}

\item{Overlap}{integer. Days, train data will be extended (overlap with test data). Default: 7}

\item{verbosity}{verbosity (int). Default: \code{0}}

\item{seed}{Seed}

\item{direct}{use model-free optimization. Default: \code{FALSE}}

\item{repeats}{Wiederholungen fuer SPOT (Optimierungslaeufe mit unterschiedlichem Seed)}

\item{funEvals}{Auswertungen fuer SPOT (Simulationen, 
die fuer einen SPOT Lauf zur Verfuegung stehen)}

\item{funEvalsFactor}{factor to increase function evaluations. Default: 0}

\item{size}{Groesse des initialen Desings}

\item{simrepeats}{Sim Wdhlg}

\item{subset}{Subset (SPOT)}

\item{parallel}{logical}

\item{percCores}{percentage}

\item{icu}{ICU Daten}

\item{icuWeights}{Gewichtung der ICU Betten}

\item{testRepeats}{number of final evaluations on the test data}

\item{resourceNames}{Name der Ressourcen}

\item{resourceEval}{Name der zu evaluierenden Ressourcen}

\item{spotEvalsParallel}{Should the spot repeats be evaluated in parallel?}

\item{tryOnTestSet}{Should results be tested on a separate test set?}
}
\description{
SPOT Aufruf zur Optimierung der babsim Parameter mit Lasso
}
