% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babsimTools.R
\name{getSyntheticData}
\alias{getSyntheticData}
\title{getSyntheticData}
\usage{
getSyntheticData(
  StartDate = "2020-09-01",
  EndDate = "2020-11-30",
  lambda = 4,
  peakData = c(21, 50, 28, 40, 42, 50),
  amntDaysSickness = 20,
  hospitalizationRates = list(rBed = 0.1347, rIntensiveBed = 0.004,
    rIntensiveBedVentilation = 0.0171)
)
}
\arguments{
\item{StartDate}{Start date. Default: \code{"2020-09-01"}}

\item{EndDate}{Start date. Default: \code{"2020-11-30"}}

\item{lambda}{Average number of daily infections. Default: 4}

\item{peakData}{Vector to define peak events. Odd entries represent days, 
even entries the number of infections. Default: \code{c(21,50, 28,40, 42,50)}, 
i.e., after 21 days 50 additional infections, after 28 days 40 additional infections,
and after 42 days 50 addditional infections to the base infection rate per day,
which is defined by \code{lambda}.}

\item{amntDaysSickness}{Length (in days) of the interval that is used to determine
the number of infected individuals that have to go to the hospital. Based on this
interval, the number of sick individuals is determined. The number of sick individuals
is multiplied by the hospitalization rate to determine the number of bed. Default: 20}

\item{hospitalizationRates}{list of hospitalization rates, i.e., percentage
of sick individuals that need a \code{bed}, or an \code{intensiveBed}, or
an \code{intensiveBedVentilation}. Default: \code{list(rBed = 0.1347, 
rIntensiveBed = 0.004,  rIntensiveBedVentilation = 0.0171)}.}
}
\value{
data frame with the following entries: 
bed=bed,
intensiveBed = intensiveBed,
intensiveBedVentilation = intensiveBedVentilation, 
Day = Day,
Infected=Infected, 
Sick = Sick)
\describe{
  \item{\code{bed}}{int: COVID-19 beds}
  \item{\code{intensiveBed}}{int: COVID-19 ICU beds}
  \item{\code{intensiveBedVentilation}}{int  COVID-19 ICU beds with ventilation}
  \item{\code{Day}}{Date, format: "2020-05-01" "2020-05-02" "2020-05-03" "2020-05-04" ...}
  \item{\code{Infected}}{int: number of infected individuals (daily)}
  \item{\code{Sick}}{int: number of sick individuals (daily)}
 }
}
\description{
Generate synthetic data
}
\examples{

dataSynth <- getSyntheticData() 

}
