% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babsimTools.R
\name{getExpCoeff}
\alias{getExpCoeff}
\title{getExpCoeff}
\usage{
getExpCoeff(x, y, a0 = 0, b0 = 0)
}
\arguments{
\item{x}{x data}

\item{y}{y data}

\item{a0}{start value (default: 1)}

\item{b0}{start value (default: 1)}
}
\value{
named vector of coefficients ("a", "b")
}
\description{
Get coeff from an exponential fit
}
\examples{
age <- c(2,10,25,47,70,90)
risk <- c(0.01,0.07,0.15,0.65,3,12.64)
plot(age,risk)
ab <- getExpCoeff(x=age, y=risk, a0 = 1, b0 = 0)
y <- ab[1] * exp( ab[2] * age)
lines(age, y)

}
