% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babsimHospital.R
\name{babsimHospital}
\alias{babsimHospital}
\title{babsimHospital}
\usage{
babsimHospital(arrivalTimes = NULL, conf = list(), para = list(), ...)
}
\arguments{
\item{arrivalTimes}{Arrival times as generated using \code{getArrivalTimes}.}

\item{conf}{list with the following entries:
\describe{
\item{\code{seed}}{seed. Default: 123}
\item{\code{simRepeats}}{simmer repeats}
\item{\code{parallel}}{simmer parallel runs. Default: FALSE}
\item{\code{perCores}}{percentage of cores used for parallel simmer simulations. Default: 0.5 (=50 percent)}
\item{\code{ICU}}{use ICU infection data. Default: FALSE}
\item{\code{logLevel}}{log leved (0 or 1). Default: 0 (no output)}
}}

\item{para}{List with parameter settings. Can be generated with \code{\link{babsimHospitalPara}}.}

\item{...}{additional parameters passed to \code{fun}.}
}
\value{
This function returns an env list with:
\describe{
	\item{\code{xbest}}{Parameters of the best found solution (matrix).}
}
}
\description{
Simulate resource allocation in hospitals.
}
\examples{

require("simmer")
require("dplyr")
# Generate simulation data based on number of infected persons per day: 
x <- dataCovidBeds20200624
arrivalTimes <- getArrivalTimes(x$Infected) 
conf = babsimToolsConf()
y <- babsimHospital(arrivalTimes = arrivalTimes,
                   conf = babsimToolsConf(),
                   para = babsimHospitalPara())
resources <- get_mon_resources(y)
# resources <- resources \%>\% filter(resource != "nurse")
mean(resources$server)

## 2nd example (shows details):
# Generate simulation data based on number of infected persons per day: 
x <- dataCovidBeds20200624
arrivalTimes <- getArrivalTimes(x$Infected) 
para <- babsimHospitalPara()
conf <- babsimToolsConf()
conf$logLevel = 1
conf$simRepeats = 1
para$GammaShapeParameter = 0.8 
y <- babsimHospital(arrivalTimes = arrivalTimes, 
                    conf = conf, 
                    para = para)

}
