% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_babette_paths.R
\name{get_babette_paths}
\alias{get_babette_paths}
\title{Get the full paths of files in the \code{inst/extdata} folder}
\usage{
get_babette_paths(filenames)
}
\arguments{
\item{filenames}{the files' names, without the path}
}
\value{
the filenames' full paths, if and only if
  all files are present. Will stop otherwise.
}
\description{
Get the full paths of files in the \code{inst/extdata} folder
}
\examples{
library(testthat)

filenames <- c("anthus_aco.fas", "anthus_nd2.fas")
full_paths <- get_babette_paths(filenames)
expect_equal(length(full_paths), 2)
expect_true(all(file.exists(full_paths)))
}
\seealso{
for one file, use \code{\link{get_babette_path}}
}
\author{
Richèl J.C. Bilderbeek
}
