% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_noise.R
\name{add_noise}
\alias{add_noise}
\title{Add synthetic noise}
\usage{
add_noise(
  X,
  mar = NULL,
  target.snr = 2,
  precision = 0.1,
  cores = getOption("mc.cores", 1),
  pb = getOption("pb", TRUE),
  max.iterations = 1000,
  kind = c("pink", "white", "brown", "red", "power"),
  alpha = 1,
  ...
)
}
\arguments{
\item{X}{Object of class 'extended_selection_table' (created by the function \code{\link[warbleR]{selection_table}} from the warbleR package), generated 'by element', with the reference to the test sounds (typically the output of \code{\link{align_test_files}}). Must contain the following columns: 1) "sound.files": name of the .wav files, 2) "selec": unique selection identifier (within a sound file), 3) "start": start time and 4) "end": end time of selections, 5) "bottom.freq": low frequency for bandpass, 6) "top.freq": high frequency for bandpass and 7) "sound.id": ID of sounds (needed to calculate signal to noise ratio internally using \code{\link{signal_to_noise_ratio}}).}

\item{mar}{numeric vector of length 1. Specifies the margins adjacent to
the start point of the annotation over which to measure ambient noise.}

\item{target.snr}{numeric vector of length 1. Specifies the desired signal-to-noise ratio. Must be lower that the current signal-to-noise ratio. Annotations showing a signal-to-noise ratio higher than 'target.snr' will remain unchanged. Must be supplied.}

\item{precision}{numeric vector of length 1. Specifies the precision of the adjusted signal-to-noise ratio (in dB).}

\item{cores}{Numeric vector of length 1. Controls whether parallel computing is applied by specifying the number of cores to be used. Default is 1 (i.e. no parallel computing). Can be set globally for the current R session via the "mc.cores" option (see \code{\link[base]{options}}).}

\item{pb}{Logical argument to control if progress bar is shown. Default is \code{TRUE}.  Can be set globally for the current R session via the "pb" option (see \code{\link[base]{options}}).}

\item{max.iterations}{Numeric vector of length 1. Specifies the maximum number of iterations that the internal signal-to-noise adjusting routine will run before stopping. Note that in most cases the default maximum number of iterations (1000) is not reached.}

\item{kind}{Character vector of length 1 indicating the kind of noise, “white”, “pink”, “power”, "brown", or “red”. Noise is synthesized with a modified version of the function \code{\link[tuneR]{noise}}. Default is "pink" which is similar to background noise in natural environments.}

\item{alpha}{Numeric vector of length 1. The power for the power law noise (defaults are 1 for pink and 1.5 for red noise). Only used when \code{kind = "power"}.}

\item{...}{Additional arguments to be passed internally to \code{\link{signal_to_noise_ratio}}.}
}
\value{
Object 'X' in which the wave objects have been modified to match the target signal-to-noise ratio. It also includes an additional column, 'adjusted.snr', with the new signal-to-noise ratio values.
}
\description{
\code{add_noise} adds synthetic noise to annotations in extended selection tables
}
\details{
The function adds synthetic noise to sounds referenced in an extended selection table (class created by the function \code{\link[warbleR]{selection_table}} from the warbleR package) to decrease the signal-to-noise ratio. This can be useful, for instance, for evaluating the effect of background noise on signal structure. Note that the implementation is slow.
}
\examples{
\dontrun{
# load example data
data("test_sounds_est")

# make it a 'by element' extended selection table
X <- warbleR::by_element_est(X = test_sounds_est)

# add noise to the first five rows
X_noise <- add_noise(X = X[1:5, ], mar = 0.2, target.snr = 3)
}
}
\references{
{
Araya-Salas M., E. Grabarczyk, M. Quiroz-Oliva, A. Garcia-Rodriguez, A. Rico-Guevara. (2023), baRulho: an R package to quantify degradation in animal acoustic signals .bioRxiv 2023.11.22.568305.
Timmer. J and M. König (1995): On generating power law noise. Astron. Astrophys. 300, 707-710.
}
}
\seealso{
\code{\link{signal_to_noise_ratio}}

Other miscellaneous: 
\code{\link{attenuation}()},
\code{\link{noise_profile}()}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
\concept{miscellaneous}
