## https://web.stanford.edu/~kendric/birds/birdsong.html
.mnemonics <- c(
  "peet-seet",
  "fitz-bee",
  "woonk-a-chunk",
  "quack-quack-quack",
  "wheep-wheep-wheep",
  "caw-caw-caw-caw-koodle-yah",
  "looo-eee! poo-too-eee",
  "po-ta-to-chip",
  "klee-kleeklee",
  "chwee-chwee-chwee",
  "tzee-tzee-tzee-tzeeeo",
  "cheer-a-lee",
  "peeent-peeent",
  "chee-ik-ee-ik-ee-ik",
  "slip-slip-slip-slip-slip",
  "tit-tit-tit-tit",
  "who-cooks-for-you",
  "tee-zee-tee-zee-tee-zee-tee",
  "wee-zee-wee-zee-wee-zee",
  "kicky-chew",
  "pee-a-wee",
  "ku-ku-ku",
  "wenk-wenk",
  "teetsa-teetsa-teetsa",
  "chk-a-dee-dee-dee",
  "fee-bee",
  "kitty-waaak",
  "kyip-kyip-kyip",
  "beer-beer-beer",
  "zeedle-zeedle-zee-zeet-cha",
  "zee-zee-zee-zee-zoo-zee",
  "fee-der-de-lurp",
  "jay-jay-jay",
  "queedle-queedle-queedle",
  "plink-plink",
  "toot-sweet",
  "chrrr-chrrr-chrrr",
  "chick-che-day-day",
  "hooo-too-too-too-too",
  "ksh-eee",
  "cheew-iew-iew-it",
  "peet-seeeeep",
  "bubble-bubble-zeeee",
  "kit-kit-kit",
  "chuck-it-too-ee-zhew-zhew",
  "honk-honk-honk",
  "chip-chupitty-swee-ditchety",
  "seet-seet-seet-seet",
  "see-dee-dee-dee",
  "chooble-dee",
  "chitty-up",
  "zeee-zeee-zeee",
  "chyoo-chyoo-chyoo-tseee",
  "pleased-pleased-pleased-ta-meetcha",
  "chit-chit-chit-chit",
  "tic-tic-tic-tic-tic-tic",
  "kra-kra-kra-kra",
  "kip-kip-kip",
  "pee-eet",
  "poor-will",
  "wicka-wicka-wicka",
  "kee-arr",
  "chee-pa-chuh",
  "t-t-tseeep",
  "fee-beee",
  "too-wheee",
  "pee-a-weee",
  "see-see-see",
  "pee-trip-treee",
  "whee-wheeo-titi-whee",
  "whoo-whoo-whoooo",
  "hoot-a-hoot",
  "klee-klee-klee",
  "tu-tu-tu",
  "weet-churrr-chee-churrr",
  "kay-week",
  "chip-chewy",
  "tsip-a-tik",
  "veer-veer-veer-veer",
  "a-weeta-weeta-weet-tee-o",
  "pit-sit",
  "chiddik-chiddik",
  "kill-deeeeer",
  "tee-yee",
  "tyooo-tyoo",
  "ker-lee",
  "chip-chewy-chew",
  "weeta-weeta-wit-chew",
  "hooo-ahhoo-hoo-hoo",
  "see-bit-see-bit-see-bit",
  "wik-wik-wik",
  "too-too-too",
  "chik-chik",
  "chew-chew-chew",
  "ow-ow-ow-a-la",
  "quick-three-beers",
  "kyew-kyew-kyew-kyew",
  "p'cheer-p'cheer-p'cheer",
  "kwa-wee",
  "see-a-weeeet",
  "kuk-kuk-kow-kow-kow",
  "kik-kik-kik-kik-kik",
  "pip-pip-pip",
  "tsik-a-dee",
  "zee-zee-zee-zee",
  "pippit-pippit-pippit",
  "ank-ank-ank",
  "kee-yer-kee-yer-kee-yer",
  "conk-a-reeeeeeeee",
  "cheer-ee-o",
  "ji-dit-ji-dit-ji-dit",
  "t-t-t-t-t-t-t",
  "zee-chuppity-chuppity",
  "ksh-a-leeee",
  "plik-plik-plik",
  "garoo-a-a-a",
  "zit-zit-zit-zeeee-zaaay",
  "pi-weer",
  "chup-chup-tzeeee",
  "tee-shaay",
  "tu-tu-tu",
  "peet-weet-weet",
  "chu-whee",
  "weet-weet-weet-weet",
  "ching-a-ring-a-ring-a-ring",
  "shook-shook-shook-shook-shook",
  "piky-tucky-tuck",
  "tika-tika-tika",
  "veer-veer-veer-veer",
  "krik-krik",
  "pri-di-dik",
  "chup-chup-zeeee",
  "ti-ti-ti-ti-ti-ti",
  "tooy-tooy-tooy-tooy",
  "je-je-je-je-je-je",
  "pill-will-willet",
  "chee-chee-chee",
  "fweet-fweet-fweet",
  "ka-ka-ka-kowp-kowp-kowp",
  "tsyoo-tsyoo-tsyoo-tsyoo")

.onAttach <- function(libname, pkgname){
  ver <- read.dcf(file=system.file("DESCRIPTION", package=pkgname),
    fields=c("Version", "Date"))
  packageStartupMessage(paste(pkgname, ver[1], "\t", ver[2],
    "\t", sample(.mnemonics, 1)))
  options("bsims_theme" = list(
    col_H="darkolivegreen1",
    col_E="burlywood1",
    col_R="lightgrey",
    col_nest = "darkgreen", pch_nest = 3,   cex_nest = 1,
    col_vocal = "blue",     pch_vocal = 21, cex_vocal = 0.5,
    col_move = "orange",    lty_move = 1,   lwd_move = 1,
    col_det = "black",      lty_det = 1,    lwd_det = 1,
    col_tint="red", col_rint="red"))
  invisible(NULL)
}

.onUnload <- function(libpath){
  options("bsims_theme" = NULL)
  invisible(NULL)
}

