\encoding{UTF-8}
\name{clean}
\alias{clean}
\alias{cln}
\title{Clean faulty values}
\description{Cleans faulty values of a met mast object, set or specified set of a met mast. Faulty values are replaced by \code{NA}.}
\usage{
clean(mast, set, v.avg.min=0.4, v.avg.max=50, dir.clean=TRUE, 
	turb.clean=4, icing=FALSE, rep=NULL, n.rep=5)
cln(mast, set, v.avg.min=0.4, v.avg.max=50, dir.clean=TRUE, 
	turb.clean=4, icing=FALSE, rep=NULL, n.rep=5)
}
\arguments{
  \item{mast}{Met mast object created by \code{\link{createMast}}. To be ignored, if a single dataset shall be cleaned.}
  \item{set}{Set object created by \code{\link{createSet}} (if no \code{mast} is given) or set of met mast specified as set number or set name. To be ignored, if all datasets of \code{mast} shall be cleaned.}
  \item{v.avg.min}{Lower limit for wind speeds as numeric value. Default is \code{0.4} m/s. Set to \code{NULL} to omit minimum wind speed.}
  \item{v.avg.max}{Upper limit for wind speeds as numeric value. Default is \code{50} m/s. Set to \code{NULL} to omit maximum wind speed.}
  \item{dir.clean}{If \code{TRUE} (default), faulty wind direction values are excluded. Faulty values are \code{dir.avg}<0, \code{dir.avg}>360 and \code{dir.avg}, where the wind speed is lower than the \code{v.avg.min} specified.}
  \item{turb.clean}{Wind speed limit for turbulence intensity as numeric value. Turbulence intesity values are excluded for wind speeds lower then this limit. Default is 4 m/s.}
  \item{icing}{If \code{TRUE}, wind direction values are excluded, where standard deviation of wind direction is 0, assuming icing. Default is \code{FALSE}.}
  \item{rep}{Signal (or a vector of signals), for which repetitions shall be cleaned -- default is \code{NULL}.}
  \item{n.rep}{Minimum number of repetitions that shall be cleaned, as integer value -- default is \code{5}. Only used if \code{rep} is not \code{NULL}.}
}
\value{Returns the input met mast or dataset object with cleaned data.}
\details{Turbulence can be ignored for low wind speeds. Use \code{turb.clean} to clean the respective turbulence intensity values. See \code{\link{turbulence}} for more details.

If icing is detected using \code{icing}, the time stamp should be checked to exclude implausible assumptions, e.g. in summer.
	
Repetitions are often generated by a corrupted data stream between sensor and data logger. Some sensors also repeat their last captured value during calm conditions. Although they are unlikely for averaged time intervals, repetitions are no faulty values by default. Do only clean repetitions if you know your data. Note: the number of repetitions \code{n.rep} means \code{n.rep}+1 consecutive values in a dataset are identical. The default of 5 repetitions corresponds to one hour in case of a ten minutes interval.}
\author{Christian Graul}
\seealso{\code{\link{createSet}}, \code{\link{createMast}}}
\examples{
\dontrun{
# load and prepare data
data(winddata)
set40 <- createSet(height=40, v.avg=winddata[,2], v.std=winddata[,5],
  dir.avg=winddata[,14])
set30 <- createSet(height=30, v.avg=winddata[,6], v.std=winddata[,9],
  dir.avg=winddata[,16])
set20 <- createSet(height=20, v.avg=winddata[,10], v.std=winddata[,13])
ts <- formatTS(time.stamp=winddata[,1])
neubuerg <- createMast(time.stamp=ts, set40=set40, set30=set30, 
  set20=set20)

# clean faulty values of a met mast
neubuerg.clean <- clean(mast=neubuerg)

# compare a subset of the original and cleaned data
neubuerg$sets$set40$data$v.avg[660:670]
neubuerg.clean$sets$set40$data$v.avg[660:670]


# clean faulty values of a dataset
set40.clean <- clean(set=set40)
  
# clean just one dataset of a met mast
neubuerg.clean.2 <- clean(mast=neubuerg, set=1)
neubuerg.clean.2 <- clean(mast=neubuerg, set="set40")	# same as above

# change lower wind speed limit 
neubuerg.clean.3 <- clean(mast=neubuerg, v.avg.min=0.3)

# compare number of samples set to 'NA', due to lowered limit
length(which(is.na(neubuerg.clean$sets$set40$data$v.avg)==TRUE))
length(which(is.na(neubuerg.clean.3$sets$set40$data$v.avg)==TRUE))


# change wind speed limit for cleaning of turbulence intensity
neubuerg.clean.4 <- clean(mast=neubuerg, turb.clean=3)

# compare number of samples set to 'NA', due to turb.clean
neubuerg.clean$sets$set40$data$turb.int[75:100]
neubuerg.clean.4$sets$set40$data$turb.int[75:100]


# check whether icing is assumed for any samples
neubuerg.clean.5 <- clean(mast=neubuerg, set=1, v.avg.min=0, 
  v.avg.max=100, dir.clean=FALSE, turb.clean=0, icing=TRUE)
not.cleaned <- which(is.na(neubuerg$sets$set40$data$dir.avg)==TRUE)
cleaned <- which(is.na(neubuerg.clean.5$sets$set40$data$dir.avg)==TRUE)
length(cleaned)-length(cleaned)	# no icing here

# checked time stamp to exclude implausible icing assumptions
# (which makes no sense here, since cleaned is empty)
neubuerg.clean.5$time.stamp[cleaned]


# clean repetitions
neubuerg.clean.6 <- clean(mast=neubuerg, rep=c("v.avg", "dir.avg"))
neubuerg.clean.7 <- clean(mast=neubuerg, rep="v.avg", n.rep=3)
}
}
\keyword{methods}
