% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeHTTP.R
\name{transcribeHTTP}
\alias{transcribeHTTP}
\title{Execute AWS Transcribe API Request}
\usage{
transcribeHTTP(action, query = list(), body = NULL, version = "v1",
  region = NULL, key = NULL, secret = NULL, session_token = NULL, ...)
}
\arguments{
\item{action}{A character string specifying an API endpoint.}

\item{query}{An optional named list containing query string parameters and their character values.}

\item{body}{A request body}

\item{version}{A character string specifying the API version.}

\item{region}{A character string containing an AWS region. If missing, the default \dQuote{us-east-1} is used.}

\item{key}{A character string containing an AWS Access Key ID. The default is pulled from environment variable \dQuote{AWS_ACCESS_KEY_ID}.}

\item{secret}{A character string containing an AWS Secret Access Key. The default is pulled from environment variable \dQuote{AWS_SECRET_ACCESS_KEY}.}

\item{session_token}{Optionally, a character string containing an AWS temporary Session Token. If missing, defaults to value stored in environment variable \dQuote{AWS_SESSION_TOKEN}.}

\item{...}{Additional arguments passed to \code{\link[httr]{GET}}.}
}
\value{
If successful, a named list. Otherwise, a data structure of class \dQuote{aws-error} containing any error message(s) from AWS and information about the request attempt.
}
\description{
This is the workhorse function to execute calls to the Transcribe API.
}
\details{
This function constructs and signs an Polly API request and returns the results thereof, or relevant debugging information in the case of error.
}
\author{
Thomas J. Leeper
}
