% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{get_queue_url}
\alias{get_queue_url}
\title{Get a queue URL}
\usage{
get_queue_url(name, owner = NULL, query = NULL, ...)
}
\arguments{
\item{name}{A character string containing the name of the queue.}

\item{owner}{A character string containing the AWS Account ID that created the queue.}

\item{query}{A list specifying additional query arguments to be passed to the \code{query} argument of \code{\link{sqsHTTP}}.}

\item{...}{Additional arguments passed to \code{\link{sqsHTTP}}.}
}
\value{
If successful, a character string containing an SQS Queue URL. Otherwise, a data structure of class \dQuote{aws_error} containing any error message(s) from AWS and information about the request attempt.
}
\description{
Retrieves the URL for an SQS queue by its name.
}
\references{
\href{http://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_GetQueueUrl.html}{GetQueueURL}
}
\seealso{
\code{link{create_queue}} \code{link{delete_queue}} \code{\link{get_queue_attrs}} \code{\link{set_queue_attrs}}
}
\author{
Thomas J. Leeper
}
