% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic.R
\name{add_topic_permission}
\alias{add_topic_permission}
\alias{add__topic_permission}
\alias{remove_topic_permission}
\alias{remove_topic_permission}
\title{Add/remove access permissions}
\usage{
add_topic_permission(topic, label, permissions, ...)

remove_topic_permission(topic, label, ...)
}
\arguments{
\item{topic}{A character string containing an SNS Topic Amazon Resource Name (ARN).}

\item{label}{A character string containing a label for the permission.}

\item{permissions}{A named list of character strings, where the names of the list are AWS Account ID numbers and the list elements are SNS API endpoints (e.g. \dQuote{Publish}, \dQuote{Subscribe}, \dQuote{Unsubscribe}, etc.).}

\item{...}{Additional arguments passed to \code{\link{snsHTTP}}.}
}
\value{
If successful, a logical \code{TRUE}. Otherwise, a data structure of class \dQuote{aws_error} containing any error message(s) from AWS and information about the request attempt.
}
\description{
Add/remove permissions to publish to topic
}
\details{
Add or remove a permission, which grants another AWS account permission to use an SNS topic.
}
\references{
\href{http://docs.aws.amazon.com/sns/latest/api/API_AddPermission.html}{AddPermission}
\href{http://docs.aws.amazon.com/sns/latest/api/API_RemovePermission.html}{RemovePermission}
}
\author{
Thomas J. Leeper
}
