% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accesskey.R
\name{create_key}
\alias{create_key}
\alias{update_key}
\alias{delete_key}
\alias{list_keys}
\title{Manage Access Keys/Credentials}
\usage{
create_key(user, ...)

update_key(key, user, status, ...)

delete_key(key, user, ...)

list_keys(user, n, marker, ...)
}
\arguments{
\item{user}{Optionally, a character string specifying a user name or an object of class \dQuote{iam_user}. This will be retrieved by default from the \dQuote{UserName} list entry in \code{key}, if available; otherwise the user is assumed to be the user whose credentials are being used to execute the request.}

\item{\dots}{Additional arguments passed to \code{\link{iamHTTP}}.}

\item{key}{A character string specifying an access key or an object of class \dQuote{iam_key}.}

\item{status}{A character string specifying either \dQuote{Active} or \dQuote{Inactive} to status the key status to.}

\item{n}{An integer specifying the number of responses to return.}

\item{marker}{A character string specifying a marker (from a previous response) to use in paginating results}
}
\value{
\code{create_user} and \code{get_user} return objects of class \dQuote{iam_user}. \code{update_user} and \code{delete_user} return a logical \code{TRUE} (if successful) or an error. \code{list_users} returns a list of IAM user objects.
}
\description{
Retrieve, create, update, and delete IAM access keys
}
\examples{
\dontrun{
# list access keys
list_keys()

# create a user key
u <- create_user("example-user")
str(k <- create_key(u))

# toggle key status to inactive
update_key(k, u, "Inactive")
list_keys(u)

# cleanup
delete_key(k)
delete_user(u)
}
}
\seealso{
\code{\link{create_user}}
}
