% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_provision_byoip_cidr}
\alias{ec2_provision_byoip_cidr}
\title{Provision Byoip Cidr}
\usage{
ec2_provision_byoip_cidr(
  Cidr,
  CidrAuthorizationContext = NULL,
  PubliclyAdvertisable = NULL,
  Description = NULL,
  DryRun = NULL,
  PoolTagSpecification = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{Cidr}{Character. The public IPv4 or IPv6 address range, in CIDR notation.}

\item{CidrAuthorizationContext}{Object. A signed document that proves that you are authorized to bring the specified IP address range to...[optional]}

\item{PubliclyAdvertisable}{Logical.   (IPv6 only) Indicate whether the address range will be publicly advertised to the internet.[optional]}

\item{Description}{Character. A description for the address range and the address pool.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{PoolTagSpecification}{List. The tags to apply to the address pool.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Provision Byoip Cidr
}
\section{Cidr}{

The public IPv4 or IPv6
address range, in CIDR notation. The most specific IPv4 prefix that you
can specify is /24. The most specific IPv6 prefix you can specify is
/56. The address range cannot overlap with another address range that
you\'ve brought to this or another Region.
}

\section{CidrAuthorizationContext}{

A signed
document that proves that you are authorized to bring the specified IP
address range to Amazon using BYOIP.
}

\section{PubliclyAdvertisable}{


(IPv6 only) Indicate whether the address range will be publicly
advertised to the internet.

Default: true
}

\section{Description}{

A description for the address range and the address
pool.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{PoolTagSpecification}{

The tags to apply to the
address pool.
}

