% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_subnet_attribute}
\alias{ec2_modify_subnet_attribute}
\title{Modify Subnet Attribute}
\usage{
ec2_modify_subnet_attribute(
  SubnetId,
  AssignIpv6AddressOnCreation = NULL,
  MapPublicIpOnLaunch = NULL,
  MapCustomerOwnedIpOnLaunch = NULL,
  CustomerOwnedIpv4Pool = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{SubnetId}{Character. The ID of the subnet.}

\item{AssignIpv6AddressOnCreation}{Object.   Specify \code{true} to indicate that network interfaces created in the specified subnet should be assigned...[optional]}

\item{MapPublicIpOnLaunch}{Object. Specify \code{true} to indicate that network interfaces attached to instances created in the specified...[optional]}

\item{MapCustomerOwnedIpOnLaunch}{Object.   Specify \code{true} to indicate that network interfaces attached to instances created in the specified...[optional]}

\item{CustomerOwnedIpv4Pool}{Character.   The customer-owned IPv4 address pool associated with the subnet.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Modifies a subnet attribute. You can only modify
one attribute at a time.
}
\section{SubnetId}{

The ID of the subnet.
}

\section{AssignIpv6AddressOnCreation}{


Specify \code{true} to indicate that network interfaces created in the
specified subnet should be assigned an IPv6 address. This includes a
network interface that\'s created when launching an instance into the
subnet (the instance therefore receives an IPv6 address).

If you enable the IPv6 addressing feature for your subnet, your network
interface or instance only receives an IPv6 address if it\'s created
using version \code{2016-11-15} or later of the Amazon EC2 API.
}

\section{MapPublicIpOnLaunch}{

Specify \code{true} to indicate that network interfaces
attached to instances created in the specified subnet should be assigned
a public IPv4 address.
}

\section{MapCustomerOwnedIpOnLaunch}{


Specify \code{true} to indicate that network interfaces attached to instances
created in the specified subnet should be assigned a customer-owned IPv4
address.

When this value is \code{true}, you must specify the customer-owned IP pool
using \code{CustomerOwnedIpv4Pool}.
}

\section{CustomerOwnedIpv4Pool}{


The customer-owned IPv4 address pool associated with the subnet.

You must set this value when you specify \code{true} for
\code{MapCustomerOwnedIpOnLaunch}.
}

