% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_detach_network_interface}
\alias{ec2_detach_network_interface}
\title{Detach Network Interface}
\usage{
ec2_detach_network_interface(
  AttachmentId,
  DryRun = NULL,
  Force = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{AttachmentId}{Character. The ID of the attachment.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{Force}{Logical.   Specifies whether to force a detachment.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Detaches a
network interface from an instance.
}
\section{AttachmentId}{

The ID of the
attachment.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{Force}{


Specifies whether to force a detachment.
\itemize{
\item Use the \code{Force} parameter only as a last resort to detach a network
interface from a failed instance.
\item If you use the \code{Force} parameter to detach a network interface, you
might not be able to attach a different network interface to the
same index on the instance without first stopping and starting the
instance.
\item If you force the detachment of a network interface, the \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html}{instance metadata}
might not get updated. This means that the attributes associated
with the detached network interface might still be visible. The
instance metadata will get updated when you stop and start the
instance.
}
}

