% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_volumes}
\alias{ec2_describe_volumes}
\title{Describe Volumes}
\usage{
ec2_describe_volumes(
  Filter = NULL,
  VolumeId = NULL,
  DryRun = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{VolumeId}{List. The volume IDs.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{MaxResults}{Integer. The maximum number of volume results returned by \code{DescribeVolumes} in paginated output.[optional]}

\item{NextToken}{Characters. The token for the next page of results[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Describe Volumes
}
\section{Filter}{


The filters.
\itemize{
\item \code{attachment.attach-time} - The time stamp when the attachment
initiated.
\item \code{attachment.delete-on-termination} - Whether the volume is deleted
on instance termination.
\item \code{attachment.device} - The device name specified in the block device
mapping (for example, \verb{/dev/sda1}).
\item \code{attachment.instance-id} - The ID of the instance the volume is
attached to.
\item \code{attachment.status} - The attachment state (\code{attaching} \|
\code{attached} \| \code{detaching}).
\item \code{availability-zone} - The Availability Zone in which the volume was
created.
\item \code{create-time} - The time stamp when the volume was created.
\item \code{encrypted} - Indicates whether the volume is encrypted (\code{true} \|
\code{false})
\item \code{multi-attach-enabled} - Indicates whether the volume is enabled for
Multi-Attach (\code{true} \| \code{false})
\item \code{fast-restored} - Indicates whether the volume was created from a
snapshot that is enabled for fast snapshot restore (\code{true} \|
\code{false}).
\item \code{size} - The size of the volume, in GiB.
\item \code{snapshot-id} - The snapshot from which the volume was created.
\item \code{status} - The state of the volume (\code{creating} \| \code{available} \|
\verb{in-use} \| \code{deleting} \| \code{deleted} \| \code{error}).
\item \code{tag}:\ - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{volume-id} - The volume ID.
\item \code{volume-type} - The Amazon EBS volume type (\code{gp2} \| \code{gp3} \| \code{io1}
\| \code{io2} \| \code{st1} \| \code{sc1}\| \code{standard})
}
}

\section{VolumeId}{

The volume IDs.
}

\section{DryRun}{

Checks whether
you have the required permissions for the action, without actually
making the request, and provides an error response. If you have the
required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

\section{MaxResults}{

The
maximum number of volume results returned by \code{DescribeVolumes} in
paginated output. When this parameter is used, \code{DescribeVolumes} only
returns \code{MaxResults} results in a single page along with a \code{NextToken}
response element. The remaining results of the initial request can be
seen by sending another \code{DescribeVolumes} request with the returned
\code{NextToken} value. This value can be between 5 and 500; if \code{MaxResults}
is given a value larger than 500, only 500 results are returned. If this
parameter is not used, then \code{DescribeVolumes} returns all results. You
cannot specify this parameter and the volume IDs parameter in the same
request.
}

