% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_client_vpn_endpoint}
\alias{ec2_modify_client_vpn_endpoint}
\title{Modify Client Vpn Endpoint}
\usage{
ec2_modify_client_vpn_endpoint(
  ClientVpnEndpointId,
  ServerCertificateArn = NULL,
  ConnectionLogOptions = NULL,
  DnsServers = NULL,
  VpnPort = NULL,
  Description = NULL,
  SplitTunnel = NULL,
  DryRun = NULL,
  SecurityGroupId = NULL,
  VpcId = NULL,
  SelfServicePortal = NULL,
  ClientConnectOptions = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{ClientVpnEndpointId}{String. The ID of the Client VPN endpoint to modify.}

\item{ServerCertificateArn}{String. The ARN of the server certificate to be used.[optional]}

\item{ConnectionLogOptions}{Object.   Information about the client connection logging options.[optional]}

\item{DnsServers}{Object. Information about the DNS servers to be used by Client VPN connections.[optional]}

\item{VpnPort}{Integer.   The port number to assign to the Client VPN endpoint for TCP and UDP traffic.[optional]}

\item{Description}{String. A brief description of the Client VPN endpoint.[optional]}

\item{SplitTunnel}{Logical.   Indicates whether the VPN is split-tunnel.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{SecurityGroupId}{List. The IDs of one or more security groups to apply to the target network.[optional]}

\item{VpcId}{String. The ID of the VPC to associate with the Client VPN endpoint.[optional]}

\item{SelfServicePortal}{String. Specify whether to enable the self-service portal for the Client VPN endpoint.[optional]}

\item{ClientConnectOptions}{Object. The options for managing connection authorization for new client connections.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modifies the specified Client VPN
endpoint. Modifying the DNS server resets existing client
connections.
}
\section{ClientVpnEndpointId}{

The ID of the Client VPN
endpoint to modify.
}

\section{ServerCertificateArn}{

The ARN of the server
certificate to be used. The server certificate must be provisioned in
AWS Certificate Manager (ACM).
}

\section{ConnectionLogOptions}{


Information about the client connection logging options.

If you enable client connection logging, data about client connections
is sent to a Cloudwatch Logs log stream. The following information is
logged:
\itemize{
\item Client connection requests
\item Client connection results (successful and unsuccessful)
\item Reasons for unsuccessful client connection requests
\item Client connection termination time
}
}

\section{DnsServers}{

Information about the DNS servers to be used by
Client VPN connections. A Client VPN endpoint can have up to two DNS
servers.
}

\section{VpnPort}{


The port number to assign to the Client VPN endpoint for TCP and UDP
traffic.

Valid Values: \code{443} \| \code{1194}

Default Value: \code{443}
}

\section{Description}{

A brief description of the Client VPN
endpoint.
}

\section{SplitTunnel}{


Indicates whether the VPN is split-tunnel.

For information about split-tunnel VPN endpoints, see \href{https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html}{Split-Tunnel AWS Client VPN Endpoint}
in the \emph{AWS Client VPN Administrator Guide}.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{SecurityGroupId}{

The IDs of one or more
security groups to apply to the target network.
}

\section{VpcId}{

The
ID of the VPC to associate with the Client VPN
endpoint.
}

\section{SelfServicePortal}{

Specify whether to enable the self-service
portal for the Client VPN endpoint.
}

\section{ClientConnectOptions}{

The options for
managing connection authorization for new client
connections.
}

